/*
 * fileReadKey2.cc: get the second key from the record at the given offset
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

char* Database::fileReadKey2(unsigned long int pos)
{
    char recordHeader[DB_HEADER_SIZE];
    char* dbkey2;
    struct stat finfo;
    uint32 key1size, key2size, valsize;

    if (stat(dbfile, &finfo) == 0)
    {
        if (pos >= DB_HEADER_SIZE && pos <= finfo.st_size)
        {
            if (lseek(dbfd, pos, SEEK_SET) != pos)
            {
                throw dbSeekFail();
            }

            if (::read(dbfd, recordHeader, DB_HEADER_SIZE) == DB_HEADER_SIZE)
            {
                memcpy(&key1size, &recordHeader[4], 4);
                memcpy(&key2size, &recordHeader[8], 4);
                memcpy(&valsize, &recordHeader[12], 4);

                dbkey2 = new char[key2size+1];
                dbkey2[key2size] = '\0';

                if (lseek(dbfd, valsize+key1size, SEEK_CUR) != pos+DB_HEADER_SIZE+valsize+key1size)
                {
                    throw dbSeekFail();
                }

                if (::read(dbfd, dbkey2, key2size) != key2size)
                {
                    throw dbReadFail();
                }
            }
            else
            {
                throw dbReadFail();
            }
        }
        else
        {
            throw dbBadFormat();
        }
    }
    else
    {
        throw dbStatFail();
    }
    return dbkey2;
}
