/*
 * fileReadKey1.cc: get the first key from the record at the given offset
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

char* Database::fileReadKey1(unsigned long pos)
{
    char recordHeader[DB_HEADER_SIZE];
    char* dbkey1;
    struct stat finfo;
    uint32 key1size, valsize;

    if (stat(dbfile, &finfo) == 0)
    {
        if (pos >= DB_HEADER_SIZE && pos <= finfo.st_size)
        {
            if (lseek(dbfd, pos, SEEK_SET) != pos)
            {
                throw dbSeekFail();
            }

            if (::read(dbfd, recordHeader, DB_HEADER_SIZE) == DB_HEADER_SIZE)
            {
                memcpy(&key1size, &recordHeader[4], 4);
                memcpy(&valsize, &recordHeader[12], 4);

                dbkey1 = new char[key1size+1];
                dbkey1[key1size] = '\0';

                if (lseek(dbfd, valsize, SEEK_CUR) != pos + valsize + DB_HEADER_SIZE)
                {
                    throw dbSeekFail();
                }

                if (::read(dbfd, dbkey1, key1size) != key1size)
                {
                    throw dbReadFail();
                }
            }
            else
            {
                throw dbReadFail();
            }
        }
        else
        {
            throw dbBadFormat();
        }
    }
    else
    {
        throw dbStatFail();
    } 

    return dbkey1;
}
