/*
 * fileRead.cc: get the value of the record at the given offset
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

char* Database::fileRead(unsigned long pos)
{
    char recordHeader[DB_HEADER_SIZE];
    char* dbvalue;
    struct stat finfo;
    uint32 valsize;

    if (stat(dbfile, &finfo) == 0)
    {
        if (pos >= DB_HEADER_SIZE && pos <= finfo.st_size)
        {
            if (lseek(dbfd, pos, SEEK_SET) != pos)
            {
                throw dbSeekFail();
            }

            if (::read(dbfd, recordHeader, DB_HEADER_SIZE) == DB_HEADER_SIZE)
            {
                memcpy(&valsize, &recordHeader[12], 4);

                dbvalue = new char[valsize+1];
                dbvalue[valsize] = '\0';

                if (::read(dbfd, dbvalue, valsize) != valsize)
                {
                    throw dbReadFail();
                }
            }
        }
        else
        {
            throw dbBadFormat();
        }
    }
    else
    {
        throw dbStatFail();
    }
    return dbvalue;
}
