/*
 * fileInit.cc: initialize the file handling layer
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::fileInit(void)
{
    char fileHeader[DB_HEADER_SIZE];
    uint32 dbtime;
    struct stat st;
    int retc;

    retc = stat(dbfile, &st);

    if (retc == 0 && st.st_size >= DB_HEADER_SIZE)
    {
        uint16 versmajor, versminor;

        /* open the database file */
        if ((dbfd = open(dbfile, O_RDWR, 0664)) < 0)
        {
            throw dbOpenFail();
        }

        /* check to see if the database is valid */
        if (::read(dbfd, fileHeader, DB_HEADER_SIZE) != DB_HEADER_SIZE)
        {
            throw dbReadFail();
        }

        memcpy(&versmajor, &fileHeader[8], 2);
        memcpy(&versminor, &fileHeader[10], 2);
        memcpy(&dbtime, &fileHeader[12], 4);

        defragTime = dbtime;

        if ((versmajor > DB_VERSION_MAJOR) || (versmajor == DB_VERSION_MAJOR && versminor > DB_VERSION_MINOR))
        {
            close(dbfd);
            throw dbBadVersion();
        }
    }
    else
    {
        uint16 tmpver;

        if ((dbfd = open(dbfile, O_CREAT | O_RDWR, 0600)) < 0)
        {
            throw dbCreateFail();
        }

        strcpy((char*) fileHeader, "Olympus");
        fileHeader[7] = '\0';

        defragTime = time(NULL);
        dbtime = defragTime;

        tmpver = DB_VERSION_MAJOR;
        memcpy(&fileHeader[ 8], &tmpver, 2);
        tmpver = DB_VERSION_MINOR;
        memcpy(&fileHeader[10], &tmpver, 2);
        memcpy(&fileHeader[12], &dbtime, 4);
        memset(&fileHeader[16], 0, 16);

        /* write the header to the new file */
        if (::write(dbfd, fileHeader, DB_HEADER_SIZE) != DB_HEADER_SIZE)
        {
            close(dbfd);
            throw dbWriteFail();
        }
    }
}
