/*
 * fileDefrag.cc: defrag the database
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

void Database::fileDefrag(void)
{
    uint32 recordsize, readsize, readoffset, writeoffset;
    uint32 readtotal(0);
    char record[8192];
    int dffd, len;

    if ((dffd = open(dbfile, O_RDWR)) < 0)
    {
        throw dbOpenFail();
    }

    if ((readoffset = lseek(dbfd, DB_HEADER_SIZE, SEEK_SET)) != DB_HEADER_SIZE)
    {
        throw dbSeekFail();
    }

    if ((writeoffset = lseek(dffd, DB_HEADER_SIZE, SEEK_SET)) != DB_HEADER_SIZE)
    {
        throw dbSeekFail();
    }

    while ((len = ::read(dbfd, &recordsize, 4)) > 0)
    {
        if (!(recordsize & RECORD_DELETE))
        {
            if (readoffset != writeoffset)
            {
                while (readtotal < recordsize)
                {
                    if ((readsize = sizeof(record)) > recordsize - readtotal)
                        readsize = recordsize - readtotal;

                    if ((readsize = ::read(dbfd, record, readsize)) > 0)
                    {
                        if (::write(dffd, &recordsize, 4) != 4)
                        {
                            throw dbWriteFail();

                        }
                        if (::write(dffd, record, readsize) != readsize)
                        {
                            throw dbWriteFail();
                        }
                    }
                    else
                    {
                        throw dbReadFail();
                    }
                    readtotal += readsize;
                }
                readtotal = 0;
                readoffset += recordsize + 4;
                writeoffset += recordsize + 4;
            }
            else
            {
                readoffset = lseek(dbfd, recordsize, SEEK_CUR);
                writeoffset = lseek(dffd, recordsize + 4, SEEK_CUR);
            }
        }
        else
        {
            /* record is marked for deletion, move ahead to the next header */
            readoffset = lseek(dbfd, recordsize & DELETE_RECORD, SEEK_CUR);
        }
    }
    updateDefragTime(dffd);
    //ftruncate(dffd, readoffset - writeoffset);
    truncate(dbfile, writeoffset);
    close(dffd);
}
