/*
 * checkOffset.cc: check a given offset to see if a key combination exists
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "database.h"

bool Database::checkOffset(unsigned long offset, const char* key1, const char* key2)
{
    char recordHeader[DB_HEADER_SIZE];
    uint32 key1size, key2size, valsize;
    int len;

    if (lseek(dbfd, offset, SEEK_SET) != offset)
    {
        throw dbSeekFail();
    }

    if (::read(dbfd, recordHeader, DB_HEADER_SIZE) == DB_HEADER_SIZE)
    {
        memcpy(&key1size, &recordHeader[4], 4);
        memcpy(&key2size, &recordHeader[8], 4);

        if (strlen(key1) == key1size && strlen(key2) == key2size)
        {
            unsigned char dbkey1[key1size+1];
            unsigned char dbkey2[key2size+1];

            memcpy(&valsize, &recordHeader[12], 4);

            if (lseek(dbfd, valsize, SEEK_CUR) != offset + DB_HEADER_SIZE + valsize)
            {
                throw dbSeekFail();
            }

            if (::read(dbfd, dbkey1, key1size) != key1size)
            {
                throw dbReadFail();
            }

            if (::read(dbfd, dbkey2, key2size) != key2size)
            {
                throw dbReadFail();
            }

            dbkey1[key1size] = '\0';
            dbkey2[key2size] = '\0';

            if (strcmp(key1, (char*) dbkey1) == 0 && strcmp(key2, (char*) dbkey2) == 0)
            {
                return true;
            }
        }
    }
    return false;
}
