/*
 * randunix.cc:
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "config.h"
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#ifdef HAVE_GETRUSAGE
  #include <sys/resource.h>
#endif /* HAVE_GETRUSAGE */
#include "random.h"

void CSPRNG::fastPoll(void)
{
#ifdef HAVE_GETRUSAGE
    {
        struct rusage ru;
        unsigned long temp;

        getrusage(RUSAGE_SELF, &ru);
        addRandom(&ru, sizeof(ru));
    }
#endif /* HAVE_GETRUSAGE */
#ifdef HAVE_CLOCK
    {
        clock_t temp(clock());

        addRandom(&temp, sizeof(clock_t));
    }
#endif /* HAVE_CLOCK */
#ifdef HAVE_GETTIMEOFDAY
    {
        struct timeval tv;

        gettimeofday(&tv, NULL);
        addRandom(&tv.tv_sec, sizeof(tv.tv_sec));
        addRandom(&tv.tv_usec, sizeof(tv.tv_usec));
    }
#endif /* HAVE_GETTIMEOFDAY */
#ifdef HAVE_GETPID
    {
        pid_t pid(getpid());

        addRandom(&pid, sizeof(pid_t));
    }
#endif /* HAVE_GETPID */
#ifdef HAVE_GETPPID
    {
        pid_t ppid(getpid());

        addRandom(&ppid, sizeof(pid_t));
    }
#endif /* HAVE_GETPPID */
#ifdef HAVE_GETUID
    {
        uid_t uid(getuid());

        addRandom(&uid, sizeof(uid_t));
    }
#endif /* HAVE_GETUID */
#ifdef HAVE_GETGID
    {
        gid_t gid(getgid());

        addRandom(&gid, sizeof(gid_t));
    }
#endif /* HAVE_GETGID */
#ifdef HAVE_PGRP
    {
        pid_t pgid(getpgrp());

        addRandom(&pgid, sizeof(pid_t));
    }
#endif /* HAVE_PGRP */
}
