/*
 * sha.h: header for sha.cc
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __sha_h_
#define __sha_h_

#define SHA_BLOCK_SIZE              80
#define SHA_DIGEST_SIZE             20

class SHA
{
    public:
        SHA::SHA(void);
        SHA::~SHA(void);

        void hash(const unsigned char *data, unsigned char *digest, unsigned long len);
        void update(const unsigned char *data, unsigned long len);
        void final(unsigned char *digest);
        void transform(const unsigned char *data, unsigned char *digest);
    private:
        void transform(const unsigned char *block);
        void reset(void);

        unsigned char buffer[64];       // temporary buffer
        unsigned long hl,ll;            // message length
        unsigned long h0,h1,h2,h3,h4;
};

#endif /* __sha_h_ */
