/*
 * random.h: a pseudo random number generator
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __random_h_
#define __random_h_

#include "sha.h"

#define RANDOM_BLOCK_SIZE       SHA_BLOCK_SIZE
#define RANDOM_DIGEST_SIZE      SHA_DIGEST_SIZE
#define RANDOM_POOL_SIZE        640

class CSPRNG
{
    public:
        CSPRNG(void);

        unsigned char *getRandom(int size);
    private:
        unsigned char rndpool[RANDOM_POOL_SIZE];
        unsigned char keypool[RANDOM_POOL_SIZE];
        int readpos;
        int writepos;
        bool mixed;
        int balance;

        void randomPoll(int size);
        void fastPoll(void);
        void mix(unsigned char *pool);
        void addRandom(const void *buffer, int size);
        void extractData(unsigned char *buffer, int size);
};

#endif /* __random_h_ */
