/*
 * dh.h: a simple implementation of Diffie-Hellman key exchange
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __dh_h_
#define __dh_h_

class DH
{
    public:
        DH(CSPRNG *random, struct BigNum *prime, struct BigNum *generator);
        ~DH(void);

        struct BigNum *publickey(void);
        struct BigNum *privatekey(void);
        void generate(struct BigNum *f);

    private:
        CSPRNG *RNG;                    /* random number generator */
        struct BigNum *p;               /* safe prime p */
        struct BigNum *g;               /* generator g */
        struct BigNum *k;               /* g^x mod p */
        struct BigNum *K;               /* f^x mod p */
        struct BigNum *x;               /* 1 < x < (p-1)/2 */

        void init(void);
};

#endif /* __dh_h_ */
