/*
 * des.h: header for des.cc
 *
 * Copyright (c) 1999-2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __des_h_
#define __des_h_

#define DES_DECRYPT         0
#define DES_ENCRYPT         1

class DES
{
    public:
        DES(unsigned char *key, int klen);
        DES(unsigned char *key, int klen, unsigned char *ivect, int ivlen);

        unsigned long padLength(int len);
        void resetIV(void);

        void cipherECB(unsigned char *src, unsigned char *dest, int length, bool encrypt);
        void cipherCBC(unsigned char *src, unsigned char *dest, int length, bool encrypt);

        unsigned char *encipher(unsigned char *message, int length);
        unsigned long decipher(unsigned char *message, int length);

    private:
        unsigned long iv[2];            /* initialization vector */
        unsigned long oiv[2];           /* original initialization vector */
        unsigned long esk[32];          /* encryption subkeys */
        unsigned long dsk[32];          /* decryption subkeys */

        DES(void) {}
        inline void iperm(unsigned long &lb, unsigned long &rb);
        inline void fperm(unsigned long &lb, unsigned long &rb);
        void keySchedule(unsigned char *key, unsigned long *subkeys);
        void blockCipherECB(unsigned char *block, unsigned char *to, bool encrypt);
        void blockCipherCBC(unsigned char *block, unsigned char *to, bool encrypt);
    friend class TripleDES;
};

class TripleDES: public DES
{
    public:
        TripleDES(unsigned char *key, int klen);
        TripleDES(unsigned char *key, int klen, unsigned char *ivect, int ivlen);

        void cipherECB(unsigned char *src, unsigned char *dest, int length, bool encrypt);
        void cipherCBC(unsigned char *src, unsigned char *dest, int length, bool encrypt);

        unsigned char *encipher(unsigned char *message, int length);
        unsigned long decipher(unsigned char *message, int length);

    private:
        unsigned long esk[96];          /* encryption subkeys */
        unsigned long dsk[96];          /* decryption subkeys */

        void blockCipherECB(unsigned char *block, unsigned char *to, bool encrypt);
        void blockCipherCBC(unsigned char *block, unsigned char *to, bool encrypt);
};

#endif /* __des_h_ */
