/*
 * cipher.h
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __cipher_h_
#define __cipher_h_

#include "des.h"
#include "sha.h"

#define CIPHER_NONE                 0   /* no encryption */
#define CIPHER_DES                  1   /* DES CBC */
#define CIPHER_3DES                 2   /* 3DES CBC */

class cipher
{
    public:
        cipher(void);
        cipher(int type, unsigned char *key, int klen, unsigned char *iv, int ivlen);
        ~cipher(void);

        char *b10to16(unsigned char *ptr, int length);
        unsigned char *b16to10(char *ptr, int length);

        char *fileDigest(const char *filename);

        void setCipher(int type, unsigned char *key, int klen, unsigned char *iv, int ivlen);

        void encrypt(unsigned char *src, unsigned char *dest, int length);
        void decrypt(unsigned char *src, unsigned char *dest, int length);

        char *cipherList(void);

        int cipherNumber(char *name);
        char *cipherName(int type);

        int blocklength(int type);
        int keylength(int type);

    private:
        int cipherType;

        union {
            DES *des;
            TripleDES *des3;
        } context;
};

#endif /* __cipher_h_ */
