#ifndef _STACKBAR_BTN_H
#define _STACKBAR_BTN_H

#include <qcolor.h>
#include <qstring.h>
#include <qwidget.h>
#include <qfont.h>
#include <qpalette.h>
#include <qpixmap.h>

class QStackBarBtn
{
protected:
	QColorGroup *_color, *_selColor, *_hiColor;
	QFont _font, _selFont, _hiFont;
	QColor _fcolor, _fselcolor, _fhicolor;
	QString _label;
	QWidget *pWidget;
	QPixmap *pPixmap;

public:
	QStackBarBtn( QString, QWidget * );
	QStackBarBtn( QString, QWidget *, QColor );

	virtual ~QStackBarBtn();

	QFont *selFont() { return &_selFont; }
	QFont *hiFont() { return &_hiFont; }
	QFont *font() { return &_font; }

	QPixmap *pixmap() { return pPixmap; }

	QColorGroup *selColor() { return _selColor; }
	QColorGroup *hiColor() { return _hiColor; }
	QColorGroup *color() { return _color; }

	void setSelColor( QColor  );
	void setHiColor( QColor  );
	void setColor( QColor  );

	void setFontColor( QColor c ) { _fcolor=c; }
	void setFontSelColor( QColor c ) { _fselcolor=c; }
	void setFontHiColor( QColor c ) { _fhicolor=c; }

	void setPixmap( QPixmap * );

	QColor fontColor() { return _fcolor; }
	QColor fontSelColor() { return _fselcolor; }
	QColor fontHiColor() { return _fhicolor; }

	QString label() { return _label; }

	void setLabel( QString s ) { _label=s; }

	QWidget *widget() { return pWidget; }
	void setWidget( QWidget * );
};

#endif
