#ifndef _QSTACKBAR_H
#define _QSTACKBAR_H

#include <qpushbutton.h>
#include <qlist.h>
#include <qevent.h>

class QStackBarBtn;

class QStackBar : public QWidget
{
Q_OBJECT;

protected:
	QList <QStackBarBtn> *pButtons;
	int curPage;

	int curHighlight;
	int _stackHeight;

protected:
	void resizeEvent( QResizeEvent * );
	void paintEvent( QPaintEvent * );
	void mouseMoveEvent( QMouseEvent * );
	void mousePressEvent( QMouseEvent * );

	int whichButton(int, int);
	void rearrangeButtons(int,int);

signals:
	void pageSelected( int );
	void pageHighlighted(int);
	
public:
	QStackBar( QWidget *parent=0, const char *name=0 );
	virtual ~QStackBar();

	void addPage( QStackBarBtn * );
	void setCurPage( int );

	void setButtonHeight(int);

	/*!
	 * \brief Gets the button heights
	 *
	 * All buttons must have the same height, here is where you set it.
	 */
	int buttonHeight() { return _stackHeight; }
};

#endif
