/*************************************************************************/
/*                                                                       */
/*  Regexx - Regular Expressions C++ solution.                           */
/*                                                                       */
/*  http://projects.nn.com.br/                                           */
/*                                                                       */
/*  Copyright (C) 2000 Gustavo Niemeyer <gustavo@nn.com.br>              */
/*                                                                       */
/*  This library is free software; you can redistribute it and/or        */
/*  modify it under the terms of the GNU Library General Public          */
/*  License as published by the Free Software Foundation; either         */
/*  version 2 of the License, or (at your option) any later version.     */
/*                                                                       */
/*  This library is distributed in the hope that it will be useful,      */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    */
/*  Library General Public License for more details.                     */
/*                                                                       */
/*  You should have received a copy of the GNU Library General Public    */
/*  License along with this library; if not, write to the                */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,         */
/*  Boston, MA  02111-1307, USA.                                         */
/*                                                                       */
/*************************************************************************/

// $Revision: 1.3 $
// $Date: 2000/04/05 00:29:22 $

#include "regexx.hh"

const unsigned int&
regexx::Regexx::exec(int _flags)
  throw(CompileException)
{
  if(!m_compiled) {
    int cflags =
      ((_flags&basic)?0:REG_EXTENDED)
      | ((_flags&nocase)?REG_ICASE:0)
      | ((_flags&nomatch)&&(!_flags&global)?REG_NOSUB:0)
      | ((_flags&newline)?REG_NEWLINE:0);
    int compret = regcomp(&m_preg,m_expr.c_str(),cflags);
    if(compret != 0) {
      char buffer[50];
      regerror(compret,&m_preg,buffer,50);
      throw CompileException(buffer);
    }
  }

  match.clear();
  m_compiled = true;

  int eflags = ((_flags&notbol)?REG_NOTBOL:0) | ((_flags&noteol)?REG_NOTEOL:0);

  bool ret;
  regmatch_t* pm;

  if((_flags&nomatch) && !(_flags&global))
    ret = (regexec(&m_preg,m_str.c_str(),0,NULL,eflags) != REG_NOMATCH);
  else {
    pm = new regmatch_t[m_preg.re_nsub+2];
    ret = (regexec(&m_preg,m_str.c_str(),m_preg.re_nsub+2,pm,eflags)
	   != REG_NOMATCH);
  }

  m_matches = 0;
  int last = 0;

  if(_flags&global) {
    if(_flags&nomatch)
      while(ret) {
	m_matches++;
	last += pm[0].rm_eo;
	ret = (regexec(&m_preg,m_str.c_str()+last,m_preg.re_nsub+2,pm,0)
	       != REG_NOMATCH);
      }
    else if(_flags&noatom)
      while(ret) {
	m_matches++;
	match.push_back(RegexxMatch(m_str,last+pm[0].rm_so,
				    pm[0].rm_eo-pm[0].rm_so));
	last += pm[0].rm_eo;
	ret = (regexec(&m_preg,m_str.c_str()+last,m_preg.re_nsub+2,pm,0)
	       != REG_NOMATCH);
      }
    else
      while(ret) {
	m_matches++;
	match.push_back(RegexxMatch(m_str,last+pm[0].rm_so,
				    pm[0].rm_eo-pm[0].rm_so));
	match.back().atom.reserve(m_preg.re_nsub);
	int i = 1;
	while(pm[i].rm_so != -1) {
	  match.back().atom.push_back(RegexxMatchAtom(m_str,last+pm[i].rm_so,
						      pm[i].rm_eo-pm[i].rm_so));
	  i++;
	}
	last += pm[0].rm_eo;
	ret = (regexec(&m_preg,m_str.c_str()+last,m_preg.re_nsub+2,pm,0)
	       != REG_NOMATCH);
      }
  }
  else {
    if(_flags&nomatch) {
      if(ret)
	m_matches=1;
    }
    else if(_flags&noatom) {
      if(ret) {
	m_matches=1;
	match.push_back(RegexxMatch(m_str,last+pm[0].rm_so,
				    pm[0].rm_eo-pm[0].rm_so));
      }
    }
    else {
      if(ret) {
	m_matches=1;
	match.push_back(RegexxMatch(m_str,last+pm[0].rm_so,
				    pm[0].rm_eo-pm[0].rm_so));
	match.back().atom.reserve(m_preg.re_nsub);
	int i = 1;
	while(pm[i].rm_so != -1) {
	  match.back().atom.push_back(RegexxMatchAtom(m_str,last+pm[i].rm_so,
						      pm[i].rm_eo-pm[i].rm_so));
	  i++;
	}
      }
    }
  }
  if(!(_flags&nomatch) || (_flags&global))
    delete[] pm;
  return m_matches;
}

const string&
regexx::Regexx::replace(const string& _repstr, int _flags)
  throw(CompileException)
{
  exec(_flags&~nomatch);
  vector< pair<unsigned int,string::size_type> > v;
  v.reserve(m_preg.re_nsub);
  string::size_type pos = _repstr.find("%");
  while(pos != string::npos) {
    if(_repstr[pos-1] != '%'
       && _repstr[pos+1] >= '0'
       && _repstr[pos+1] <= '9') {
      v.push_back(pair<unsigned int,string::size_type>(_repstr[pos+1]-'0',pos));
    }
    pos = _repstr.find("%",pos+1);
  }
  m_replaced = m_str;
  vector<RegexxMatch>::reverse_iterator m;
  vector< pair<unsigned int,string::size_type> >::const_iterator i;
  for(m = match.rbegin(); m != match.rend(); m++) {
    string tmprep = _repstr;
    for(i = v.begin(); i != v.end(); i++) {
      if(i->first < m->atom.size())
	tmprep.replace(i->second,2,m->atom[i->first]);
      else
	tmprep.erase(i->second,2);
    }
    m_replaced.replace(m->start(),m->length(),tmprep);
  }
  return m_replaced;
}
