/*
 *  DLC - Utility for dynamic loading of classes
 *  Copyright (C) 1999 Martin Reinecke
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef DLC_REGISTER_H
#define DLC_REGISTER_H

/**
\file dlc_register.h
Definition of the DLC_register() macro.
This header file must be included in every file containing a definition
of a dynamically loadable class.
*/

#include "dlc_maker_base.h"

template <class T> class DLC_MAKER: public DLC_MAKER_BASE
  {
  public:
    explicit DLC_MAKER (string Id) : DLC_MAKER_BASE (Id) {}

    virtual DLC_BASE *Create() const { return new T; }
  };

/*!
\def DLC_Register(Cls)
This macro must be "called" for each dynamically loadable class.
It is just a shorthand for convenience.<br>
<tt>DLC_Register (foo)</tt> stands for<br>
<tt>static DLC_MAKER<foo> DLC_Reg_foo("foo");</tt>
\param Cls The name of the class
*/
#define DLC_Register(Cls) static DLC_MAKER<##Cls> DLC_Reg_##Cls(#Cls);

#endif
