#include <qwidget.h>
#include <qevent.h>
#include <qtimer.h>
#include <qframe.h>
#include <qcolor.h>
#include <qimage.h>
#include <qpainter.h>
#include <vector>

class EQBar : public QImage
{
    public:
        EQBar(int _height, 
              int _width,
              QColor colTo50, 
              QColor colTo80,
              QColor colTo100);
                
        ~EQBar() {}
        void setValue ( int value );        
        QRect* updateBar(QPainter& degas, int posx, int posy, bool all);
        int currentVal;        
        int paintedVal;
                
    private:                 
        void drawLines();
        int height, width;
        QColor colourA, colourB, colourC;
};

class EQDisplay : public QFrame
{
    public:
        EQDisplay(QWidget* parent,
                  int numBars = 1, 
                  int _barWidth = 0, 
                  int _height = 100,
                  int _spacerWidth = 0,
                  int _refreshRate = 10, // mseconds
                  const char * name = NULL);
         
        ~EQDisplay();

        /* setBarValue would both set the new value
           push the old value to oldVal and repaint
          that one bar 
        */
        void setBarValue(int barNo, int newValue = 0);

    protected:
        void paintEvent(QPaintEvent*);
//        void resizeEvent(QResizeEvent*);

    private:
        QTimer* refresher; // used to provide non-blocking animations
        QColor bgColor;
        vector< EQBar* > *bars;
        int barWidth, spacerWidth, refreshRate, numBars, width, height;
        void paintHBar(EQBar* paintThis);
        void paintVBar(EQBar* paintThis);
};
