#include "EQDisplay.h"
#include <qpainter.h>

EQDisplay::EQDisplay(QWidget* parent, int _numBars = 1, int _barWidth = 0, int _height, 
                     int _spacerWidth = 0, int _refreshRate = 10, const char *name = NULL)
                     :QFrame(parent, name)
{
    barWidth = _barWidth;
    spacerWidth = _spacerWidth;
    refreshRate = _refreshRate;
    numBars = _numBars;
    height = _height;
    width = (numBars * (barWidth + spacerWidth)) + spacerWidth + 4;
    int i;
    
    QColor lower(0,255,0);
    QColor mid(0,0,255);
    QColor high(255,0,0);  

    bars = new vector<EQBar*>(numBars);
    for (i = 0; i < numBars; i++)
    {
        (*bars)[i] = new EQBar(height - (4 + (spacerWidth * 2)), barWidth, lower, mid, high);
    }
    
    setFixedSize(width, height);
    setLineWidth(1);
    setMidLineWidth(0);
    setFrameStyle(Box | Raised);
}

EQDisplay::~EQDisplay() 
{
    delete bars;
}

void EQDisplay::setBarValue(int barNo, int newValue = 0)
{
    EQBar* bar = (*bars)[barNo];
    bar->setValue(newValue);
        
    if (bar->currentVal != bar->paintedVal)
    {
        QPainter picasso;    
        picasso.begin(this);
        
        QRect* redraw = bar->updateBar(picasso, barNo * (spacerWidth + barWidth) + spacerWidth + 2, spacerWidth + 1, false);
        update(*redraw);
        delete redraw;
    }

}

void EQDisplay::paintEvent(QPaintEvent * event) 
{
    QPainter picasso;    
    picasso.begin(this);
    int i, posx;
    EQBar* thisBar;
    posx = spacerWidth + 2;
    
    drawFrame(&picasso);
    for (i = 0; i < numBars; i++)
    {
        (*bars)[i]->updateBar(picasso, posx, spacerWidth + 2, true);
        posx += spacerWidth + barWidth;
    }
    
}