#include "EQDisplay.h"
#include <qapplication.h>

EQBar::EQBar( int _height, 
              int _width, 
              QColor colTo50, 
              QColor colTo75, 
              QColor colTo100)
              : QImage(_width, _height, 32)
{
    colourA = colTo50;
    colourB = colTo75;
    colourC = colTo100;
    height = _height - 1;
    width = _width;
    paintedVal = currentVal = 0;
    
    drawLines();
}

void EQBar::setValue( int value )
{
    // shortcut the obvious ones.
    if (value == 100) { currentVal = height - 1; return; }
    if (value == 0) { currentVal = 0; return; }
    
    currentVal = height * value;
    
    if ((currentVal % 100) > 49) { currentVal = currentVal / 100 + 1; }
    else { currentVal = currentVal / 100; }
}

/* draws a gradiated fill of the three colours provided 
   it mangles the colours but that's ok, this only gets
   called once */
void EQBar::drawLines()
{
    int quarter = (height + 1) * 25 / 100;
    int halfway = quarter * 2;
    int i, l; 
    int or, og, ob;
    double r,g,b;
    
    r = colourC.red() - colourB.red();
    g = colourC.green() - colourB.green();
    b = colourC.blue() - colourB.blue();
    
    r /= quarter;
    g /= quarter;
    b /= quarter;
    
    or = colourC.red(); 
    og = colourC.green();
    ob = colourC.blue();
    
    for (i = 0; i <= quarter; i++)
    {
        for (l = 0; l < width; l++)
        {
            setPixel(l, i, colourC.rgb());
        }
        
        colourC.setRgb(or - (r * i), og - (g * i), ob - (b * i));
    }
        
    r = colourB.red() - colourA.red();
    g = colourB.green() - colourA.green();
    b = colourB.blue() - colourA.blue();
    
    r /= quarter;
    g /= quarter;
    b /= quarter;
    
    or = colourB.red(); 
    og = colourB.green();
    ob = colourB.blue();
    
    
    for (i = quarter + 1; i <= halfway; i++)
    {
        for (l = 0; l < width; l++)
        {
            setPixel(l, i, colourB.rgb());
        }
        
        colourB.setRgb(or - (r * i), og - (g * i), ob - (b * i));
    }    
    
    for (i = halfway + 1; i < height + 1; i++)
    {
        for (l = 0; l < width; l++)
        {
            setPixel(l, i, colourA.rgb());
        }
    }
}

/* usd to update the bar and paint it to the widget */
QRect* EQBar::updateBar(QPainter& degas, int posx, int posy, bool all)
{
    QRect* toUpdate;
    int inverseCurrent = height - currentVal;

    if (all)
    {
        degas.fillRect(posx, posy, width, inverseCurrent, qApp->palette().normal().background());
        degas.drawImage(posx, posy + inverseCurrent, *this, 0, inverseCurrent, width, height);
        toUpdate = new QRect(posx, posy, width, height);
    }
    else if (currentVal == paintedVal) { toUpdate = new QRect(0,0,0,0); }
    else if (currentVal < paintedVal)
    {
        toUpdate = new QRect(posx, posy + inverseCurrent, width, posy + height - paintedVal);
        degas.fillRect(posx, posy, width, inverseCurrent, qApp->palette().normal().background()); //colourB);
    }
    else if (currentVal > paintedVal)
    {
        toUpdate = new QRect(posx, posy + height - paintedVal, width, posy + inverseCurrent);
        degas.setPen(colourA);
        degas.drawImage(posx, posy + inverseCurrent, *this, 0, inverseCurrent, width, height);
    }
    
    paintedVal = currentVal;
    return toUpdate;
}
