/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mod_swDisplay.h
*
*   This class implements a window to display the text in a scrollable
*   window.
*
*****************************************************************************/

#include <qmultilineedit.h>
#include <qlayout.h>
#include <qtextbrowser.h>
#include <qpushbutton.h>
#include <qdialog.h>

#include "mod_swDisplay.h"

// reimplement close event to delete this object
void mod_swDisplay::closeEvent(QCloseEvent* e)
{
    delete this;
}

mod_swDisplay::mod_swDisplay(char *_filename) : QDialog(0, "textDisplay")
{
    QVBoxLayout* mainbox;
    QPushButton* button;

    filename = _filename;
    mainbox = new QVBoxLayout(this, 0, 0, "textlayout");

    textWidget = new QTextBrowser(this, "browsetext");
    mainbox->addWidget(textWidget);

    button = new QPushButton("Save to Disk", this, "browseexit");
    connect(button, SIGNAL(clicked()), this, SLOT(saveFile()));
    mainbox->addWidget(button);

    textWidget->setSource(_filename);
}

mod_swDisplay::~mod_swDisplay()
{
}

void mod_swDisplay::saveFile()
{
    
}

