/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mod_softwarewin.h
*
*   This class implements the package manager GUI.  The GUI
*   (1) Displays existing packages.
*   (2) chooses a tar file on the local host, sends it to target, tar expands
*   it and tar's status and output is returned for the user.
*   (3) sends the "./configure" message to the target and returns
*   status and output.
*   (4) sends the "make" message to the target and returns status and output.
*   (5) sends the "make install" message to the target and returns status
*   and output.
*   (6) requests to view installed files for this package.
*
*****************************************************************************/

#ifndef _mod_softwarewin_h
#define _mod_softwarewin_h

#include "plugin.h"

// Qt headers
#include <qdialog.h>

class QComboBox;
class QMultiLineEdit;
class mod_swDisplay;

class mod_softwarewin : public QDialog
{
    Q_OBJECT

 public:
    mod_softwarewin(unsigned int mid,
                    hostObj* myhost,
                    QWidget* parent = 0,
                    const char* widgetname = 0);
    ~mod_softwarewin();

    void setInfoFile(char *file);
    void setSourceView(const char* pkg);
    void setResultFile(char* filename);
    void setFileCount(int _numberOfFiles);

 public slots:

 private slots:
    void clearFields();
    void close();
    void closeEvent(QCloseEvent* event);
    void configurepkg();
    void getpackagefile();
    void installpkg();
    void makepkg();
    void newpkg();
    void sendToHost();
    void showFile();
    void updatepkg();
    void viewFile();

 private:
    hostObj* host;
    unsigned int moduleID;
    char* resultFile;
    QString file;
    QString name;

    // widgets
    QListView* fileTree;
    QLineEdit* pkgNameWidget;
    QLineEdit* pkgFileWidget;
    QComboBox* infoFileWidget;
    QMultiLineEdit* infotext;
    QLabel* configNameWidget;
    QLineEdit* configOptionsWidget;
    QLabel* configStatusWidget;
    QLabel* makeNameWidget;
    QLineEdit* makeOptionsWidget;
    QLabel* makeStatusWidget;
    QLabel* installNameWidget;
    QLabel* installStatusWidget;
    QLabel* uninstallNameWidget;
    QLabel* uninstallStatusWidget;
    mod_swDisplay* resultDisplayWidget;

    // private methods
    QWidget* configPackage(QWidget* parent = 0);
    QWidget* infoPackage(QWidget* parent = 0);
    QWidget* installPackage(QWidget* parent = 0);
    QWidget* makePackage(QWidget* parent = 0);
    QWidget* newPackage(QWidget* parent = 0);
    QWidget* uninstallPackage(QWidget* parent = 0);
};

#endif
