/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mod_softwarewin.cc
*
*   This class implements the package manager GUI.  The GUI
*   (1) Displays existing packages.
*   (2) chooses a tar file on the local host, sends it to target, tar expands
*   it and tar's status and output is returned for the user.
*   (3) sends the "./configure" message to the target and returns
*   status and output.
*   (4) sends the "make" message to the target and returns status and output.
*   (5) sends the "make install" message to the target and returns status
*   and output.
*   (6) requests to view installed files for this package.
*
*****************************************************************************/

#include <qdialog.h>
#include <qcombobox.h>
#include <qevent.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qmultilineedit.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qstatusbar.h>

#include "mod_swDisplay.h"
#include "mod_softwarewin.h"
#include "nmSourceList.h"
#include "nmSourceBuild.h"
#include "nmSourceConfig.h"
#include "nmSourceExpand.h"

#define DEBUG_MOD_SOFTWAREWIN

// clear the fields
void mod_softwarewin::clearFields()
{
    QString entry = "";
    pkgFileWidget->setText(entry);
    pkgNameWidget->setText(entry);
}

// close the dialog
void mod_softwarewin::close()
{
#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::close: caught event");
#endif
    closeEvent(new QCloseEvent);
}

// process the actual event
void mod_softwarewin::closeEvent(QCloseEvent* event)
{
#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::closeEvent: entered");
#endif
    event->accept();
    client->deleteModule(moduleID);
}

// respond to configure package
void mod_softwarewin::configurepkg()
{
    nmSourceConfig* msg;
    QString text;

    msg = new nmSourceConfig(name.latin1(),
                             host->getRawSocket(),
                             moduleID,
                             COMMAND_CONFIGSRC);

    text = configOptionsWidget->text();
    if (! text.isNull())
    {
        msg->setOptions(text.latin1());
    }
    host->network->queueMessage((netmessage*) msg);
}

// widget for configuring the package
QWidget* mod_softwarewin::configPackage(QWidget* parent = 0)
{
    QWidget* w;
    QLabel* label;
    QGridLayout* grid;
    QGridLayout* buttongrid;
    QPushButton* button;

    w = new QWidget(parent, "ConfigPkg");
    grid = new QGridLayout(w, 8, 4, 0, 0, "config:grid");
    buttongrid = new QGridLayout(0, 0, 0, 0, 0, "config:buttongrid");
    grid->addMultiCell(buttongrid, 7, 7, 1, 3);

    // now for the contents
    configNameWidget = new QLabel("Package Name:", w, "config:Name");
    grid->addWidget(configNameWidget, 1, 1);

    configStatusWidget = new QLabel("Status: Not Configured", w,
                                    "config:statuslabel");
    grid->addWidget(configStatusWidget, 3, 1);

    label = new QLabel("Configure Options:", w, "config:optionlabel");
    grid->addWidget(label, 5, 1);

    configOptionsWidget = new QLineEdit(w, "config:optiontxt");
    grid->addWidget(configOptionsWidget, 5, 3);

    button = new QPushButton("Configure Package", w, "config:doconfig");
    buttongrid->addWidget(button, 0, 0);
    connect(button, SIGNAL(clicked()), this, SLOT(configurepkg()));

    button = new QPushButton("Display Results", w, "config:dodisplay");
    buttongrid->addWidget(button, 0, 1);
    connect(button, SIGNAL(clicked()), this, SLOT(showFile()));

    // setup the spacing
    grid->addColSpacing(0, 10);
    grid->addColSpacing(2, 10);
    grid->addColSpacing(4, 10);
    grid->addRowSpacing(0, 10);
    grid->addRowSpacing(2, 10);
    grid->addRowSpacing(4, 10);
    grid->addRowSpacing(6, 10);
    grid->addRowSpacing(8, 10);

    return (w);
}

// sets the package file name
void mod_softwarewin::getpackagefile()
{
#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::getPackageFile: looking for file");
#endif
    QString file = QFileDialog::getOpenFileName();
    pkgFileWidget->setText(file);
}

// put a file in the info tab's combobox
void mod_softwarewin::setInfoFile(char* file)
{
    QString item = file;
    infoFileWidget->insertItem(item);
}

// get information about the expanded package
QWidget* mod_softwarewin::infoPackage(QWidget* parent = 0)
{
    QWidget* w;
    QGridLayout* grid;
    QPushButton* button;
    int width;

    w = new QWidget(parent, "InfoPkg");
    grid = new QGridLayout(w, 4, 5, 0, 0, "info:grid");

    // make file selector
    infoFileWidget = new QComboBox(w, "info:infofile");
    grid->addWidget(infoFileWidget, 1, 1);

    // view the selected file with this button
    button = new QPushButton("View File", w, "info:viewbutton");
    grid->addWidget(button, 1, 3);
    connect(button, SIGNAL(clicked()), this, SLOT(viewFile()));

    // display the file here
    infotext = new QMultiLineEdit(w, "info:text");
    grid->addMultiCellWidget(infotext, 3, 3, 1, 4);

    // set the spacing in the grid
    grid->addRowSpacing(0, 10);
    grid->addRowSpacing(2, 10);
    grid->addRowSpacing(4, 10);
    grid->addColSpacing(0, 10);
    grid->addColSpacing(2, 10);
    grid->addColSpacing(5, 10);
    width = 300;
    grid->addColSpacing(4, width);

    return (w);
}

// request the server to install the package
QWidget* mod_softwarewin::installPackage(QWidget* parent = 0)
{
    QWidget* w;
    QHBoxLayout* hbox;
    QVBoxLayout* vbox;
    QPushButton* button;

    w = new QWidget(parent, "InstallPkg");

    // layout objects
    vbox = new QVBoxLayout(w, 0, 0, "install:vbox");
    hbox = new QHBoxLayout(0, 0, 0, "install:hbox");

    installNameWidget = new QLabel("Package Name:", w, "install:Name");
    vbox->addWidget(installNameWidget);

    installStatusWidget = new QLabel("Status:", w, "install:status");
    vbox->addWidget(installStatusWidget);

    vbox->addLayout(hbox);

    button = new QPushButton("Install Package", w, "install:installbutton");
    hbox->addWidget(button);
    connect(button, SIGNAL(clicked()), this, SLOT(installpkg()));

    button = new QPushButton("Display Results", w, "install:dodisplay");
    hbox->addWidget(button);
    connect(button, SIGNAL(clicked()), this, SLOT(showFile()));

    vbox->setMargin(10);
    hbox->setSpacing(5);

    return (w);
}

// request the server to install the package
void mod_softwarewin::installpkg()
{
#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::installpkg() installing package");
#endif
}

// widget to make the package
QWidget* mod_softwarewin::makePackage(QWidget* parent = 0)
{
    QWidget* w;
    QLabel* label;
    QGridLayout* grid;
    QGridLayout* buttongrid;
    QPushButton* button;

    w = new QWidget(parent, "MakePkg");
    grid = new QGridLayout(w, 8, 4, 0, 0, "make:grid");
    buttongrid = new QGridLayout(0, 0, 0, 0, 0, "make:buttongrid");
    grid->addMultiCell(buttongrid, 7, 7, 1, 3);

    // now for the contents
    makeNameWidget = new QLabel("Package Name:", w, "make:Name");
    grid->addWidget(makeNameWidget, 1, 1);

    makeStatusWidget = new QLabel("Status: Not Built", w, "make:statuslabel");
    grid->addWidget(makeStatusWidget, 3, 1);

    label = new QLabel("Make Options:", w, "make:optionlabel");
    grid->addWidget(label, 5, 1);

    makeOptionsWidget = new QLineEdit(w, "make:optiontxt");
    grid->addWidget(makeOptionsWidget, 5, 3);

    button = new QPushButton("Make Package", w, "make:doconfig");
    buttongrid->addWidget(button, 0, 0);
    connect(button, SIGNAL(clicked()), this, SLOT(makepkg()));

    button = new QPushButton("Display Results", w, "make:dodisplay");
    buttongrid->addWidget(button, 0, 1);
    connect(button, SIGNAL(clicked()), this, SLOT(showFile()));

    // setup the spacing
    grid->addColSpacing(0, 10);
    grid->addColSpacing(2, 10);
    grid->addColSpacing(4, 10);
    grid->addRowSpacing(0, 10);
    grid->addRowSpacing(2, 10);
    grid->addRowSpacing(4, 10);
    grid->addRowSpacing(6, 10);
    grid->addRowSpacing(8, 10);

    return (w);
}

// request the server to build the package.  Send the tar filename and the
// package name to the server.
void mod_softwarewin::makepkg()
{
    QString options;
    nmSourceBuild* msg;

#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::makepkg() caught event");
#endif
    msg = new nmSourceBuild(name.latin1(),
                            host->getRawSocket(),
                            moduleID,
                            COMMAND_BUILDSRC);

    options = makeOptionsWidget->text();
    if (! options.isNull())
    {
        msg->setOptions(options.latin1());
    }

    host->network->queueMessage((netmessage*) msg);
}

// constructor builds the user interface
mod_softwarewin::mod_softwarewin(unsigned int mid,
                                 hostObj* myhost,
                                 QWidget* parent = 0,
                                 const char* widgetname = 0)
    : QDialog(parent, widgetname)
{
    QMenuBar* menu;
    QPopupMenu* popup;
    QListView* fileTree;
    QTabWidget* tab;
    QWidget* configure;
    QWidget* info;
    QWidget* install;
    QWidget* make;
    QWidget* newpackage;
    QWidget* uninstall;

#if 1
    cerr << "mod_softwarewin::mod_softwarewin() entry" << endl;
#endif
    // initialize the class variables
    resultFile = 0;
    moduleID = mid;
    host = myhost;
    fileTree = 0;

    menu = new QMenuBar(this, "menubar");
    popup = new QPopupMenu;
    menu->insertItem("&Package", popup);
    popup->insertItem("&New", this, SLOT(newpkg()));
    popup->insertItem("&Update", this, SLOT(updatepkg()));
    popup->insertSeparator();
    popup->insertItem("&Close", this, SLOT(close()), CTRL+Key_W);

    QGridLayout* mainLayout = new QGridLayout(this, 0, 0);

    fileTree = new QListView(this, "FileTree");
    fileTree->addColumn("PackageName");

    tab = new QTabWidget(this, "TabMenu");

    // children for tab widget
    newpackage = newPackage(tab);
    info = infoPackage(tab);
    configure = configPackage(tab);
    debug("past package configure");
    make = makePackage(tab);
    install = installPackage(tab);
    uninstall = uninstallPackage(tab);

    // add to the tab widget
    tab->addTab(newpackage, "&New");
    tab->addTab(info, "&Information");
    tab->addTab(configure, "&Configure");
    tab->addTab(make, "&Make");
    tab->addTab(install, "&Install");
    tab->addTab(uninstall, "&Uninstall");

    mainLayout->addColSpacing(0, 10);
    mainLayout->addColSpacing(2, 5);
    mainLayout->addColSpacing(4, 10);
    mainLayout->addRowSpacing(0, menu->size().height() + 5);
    //    mainLayout->addRowSpacing(1, tab->sizeHint().height());
    mainLayout->addColSpacing(1, 100);
    mainLayout->addWidget(fileTree, 1, 1);
    //mainLayout->addColSpacing(3, tab->sizeHint().width());
    mainLayout->addColSpacing(3, tab->size().width());
    mainLayout->addWidget(tab, 1, 3);
    mainLayout->addRowSpacing(2,10);

    QStatusBar();

    resize(mainLayout->sizeHint());

#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::mod_softwarewin: constructor");
#endif
}

// destructor
mod_softwarewin::~mod_softwarewin()
{
    if (resultFile)
    {
        delete[] resultFile;
    }
#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::mod_softwarewin: leaving destructor");
#endif
}

// the widget for selecting new packages to install
QWidget* mod_softwarewin::newPackage(QWidget* parent = 0)
{
    QWidget* w;
    QGridLayout* grid, *outerGrid;
    QLabel* label;
    QHBoxLayout* btnlayout;
    QPushButton* button;
    int y;

    w = new QWidget(parent, "NewTab");

    outerGrid = new QGridLayout(w, 0, 0, 0, 0, "new:outergrid");
    grid = new QGridLayout(0, 7, 7, 0, 0, "tab1:grid");
    outerGrid->addLayout(grid, 0, 0);
    btnlayout = new QHBoxLayout(0);
    //  grid->addMultiCell(btnlayout, 5, 5, 1, 5);
    outerGrid->addLayout(btnlayout, 1, 0);

    label = new QLabel("Program &Name:", w, "new:label0");
    pkgNameWidget = new QLineEdit(w, "new:edit0");
    label->setBuddy(pkgNameWidget);
    grid->addWidget(label, 1, 1);
    grid->addWidget(pkgNameWidget, 1, 3);

    label = new QLabel("&File to Send", w, "new:label1");
    pkgFileWidget = new QLineEdit(w, "new:edit1");
    label->setBuddy(pkgFileWidget);
    grid->addWidget(label, 3, 1);
    grid->addWidget(pkgFileWidget, 3, 3);

    button = new QPushButton("...", w, "new:filebutton");
    connect(button, SIGNAL(clicked()), this, SLOT(getpackagefile()));
    grid->addWidget(button, 3, 5);

    button = new QPushButton("&Clear Fields", w, "new:clearfields");
    btnlayout->addWidget(button);
    connect(button, SIGNAL(clicked()), this, SLOT(clearFields()));

    button = new QPushButton("Send TO &Host", w, "new:sendhost");
    btnlayout->addWidget(button);
    connect(button, SIGNAL(clicked()), this, SLOT(sendToHost()));

    button = new QPushButton("Show &File", w, "new:showfile");
    btnlayout->addWidget(button);
    connect(button, SIGNAL(clicked()), this, SLOT(showFile()));

    outerGrid->setMargin(3);
    grid->addColSpacing(0, 10);
    grid->addColSpacing(2, 10);
    grid->addColSpacing(3, 250);
    grid->addColSpacing(4, 10);
    grid->addColSpacing(6, 10);
    grid->addRowSpacing(0, 10);
    grid->addRowSpacing(2, 10);
    grid->addRowSpacing(4, 10);
    grid->addRowSpacing(6, 10);
    btnlayout->setSpacing(3);

    return (w);
}

// add an element to the package list
void mod_softwarewin::setSourceView(const char *pkg)
{
    QListViewItem(fileTree, pkg);
}

void mod_softwarewin::newpkg()
{
#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("chosing new package");
#endif
}

void mod_softwarewin::updatepkg()
{
    debug("chosing update package");
}

void mod_softwarewin::sendToHost()
{
    QString file;
    QString name;
    nmSourceExpand* msg;
    int length;

#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("sending package to host");
#endif

    // error checking
    file = pkgFileWidget->text();
    name = pkgNameWidget->text();

    // if no package name is given just return
    if (name.isNull() || name.isEmpty())
    {
        QMessageBox::critical(this, "Warning!",
                              "The name field is empty\n"
                              "please enter a package name\n"
                              "to continue",
                              "Ok");
        return;
    }

    // if the file is missing or not there then warn the user and return
    if (file.isNull() || file.isEmpty())
    {
        QMessageBox::critical(this, "Warning!",
                              "Please choose a file then continue."
                              "Ok");
        return;
    }

    // check that the file is readable.
    if (access(file.ascii(), R_OK) == 0)
    {
        // send the file
#if defined(DEBUG_MOD_SOFTWAREWIN)
        debug("file to send to host %s", file.ascii());
        debug("name of the package is %s", name.data());
#endif
        msg = new nmSourceExpand(file.latin1(),
                                 name.latin1(),
                                 host->getRawSocket(),
                                 moduleID,
                                 COMMAND_EXPANDSRC);
        debug("mod_software::sendToHost() >>  message queued");
        host->network->queueMessage((netmessage*) msg);
    }
    else
    {
        length = file.length() + 51;
        char* errmsg = new char[51];
        errmsg[0] = '\0';
        strcat(errmsg, file.ascii());
        strcat(errmsg, "\nis not readable.  Please check the\n");
        strcat(errmsg, "selected file.");
        QMessageBox::critical(this, "Error!", errmsg, "Ok");
        delete errmsg;
    }
}

// sets the status label on the "Configure" tab
void mod_softwarewin::setFileCount(int numberOfFiles)
{
    QString status;
    QString number;
    int pos;

    number.setNum(numberOfFiles);
#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::setFileCount() file count=%s", number.latin1());
#endif
    status = configStatusWidget->text();
    if (status.length() > strlen("Status:"))
    {
        pos = status.find(':') + 1;
        status.truncate(pos);
        status += "Number of Files: " + number;
    }
    else
    {
        status += " Number of Files: " + number;
    }

#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::setFileCount() new status=%d", status.latin1());
#endif

    // replace the current status
    configStatusWidget->setText(status);
}

// needed for expand return to set where the results are
void mod_softwarewin::setResultFile(char *file)
{
    resultFile = file;
}

// put the file up into a readonly edit widget
void mod_softwarewin::showFile()
{
    mod_swDisplay* widget;

    if (resultFile)
    {
#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::showFile() displaying %s", resultFile);
#endif
        widget = new mod_swDisplay(resultFile);
    }
    else
    {
#if defined(DEBUG_MOD_SOFTWAREWIN)
        debug("mod_softwarewin::showFile() displaying warning");
#endif
        QMessageBox::critical(this, "Warning!!!", "File not found!", "Ok");
    }
}

// request that the server uninstall a package
QWidget* mod_softwarewin::uninstallPackage(QWidget* parent = 0)
{
    QWidget* w;
    QHBoxLayout* hbox;
    QVBoxLayout* vbox;
    QPushButton* button;

    w = new QWidget(parent, "UninnstallPkg");

    vbox = new QVBoxLayout(w, 0, 0, "uninstall:vbox");
    hbox = new QHBoxLayout(0, 0, 0, "uninstall:hbox");

    uninstallNameWidget = new QLabel("Package Name:", w, "uninstall:Name");
    vbox->addWidget(uninstallNameWidget);

    uninstallStatusWidget = new QLabel("Status:", w, "install:status");
    vbox->addWidget(uninstallStatusWidget);

    vbox->addLayout(hbox);

    button = new QPushButton("Install Package", w, "install:installbutton");
    hbox->addWidget(button);
    connect(button, SIGNAL(clicked()), this, SLOT(uninstallpkg()));

    button = new QPushButton("Display Results", w, "install:dodisplay");
    hbox->addWidget(button);
    connect(button, SIGNAL(clicked()), this, SLOT(showFile()));

    vbox->setMargin(10);
    hbox->setSpacing(5);

    return (w);
}

// request the selected file from  the server and view it
void mod_softwarewin::viewFile()
{
#if defined(DEBUG_MOD_SOFTWAREWIN)
    debug("mod_softwarewin::viewFile() caught signal");
#endif
}
