/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mod_software.h
*
*   This class implements the package manager plugin.  The package manager
*   (1) chooses a tar file on the local host, sends it to target, tar expands
*   it and tar's status and output is returned for the user.
*   (2) sends the "./configure" message to the target and returns
*   status and output.
*   (3) sends the "make" message to the target and returns status and output.
*   (4) sends the "make install" message to the target and returns status
*   and output.
*   (5) requests to view installed files for this package.
*****************************************************************************/

#ifndef _mod_software_h
#define _mod_software_h

#include "plugin.h"

class mod_softwarewin;

class mod_software : public plugin
{
 public:
    mod_software();
    ~mod_software();

    // reimplemented from plugin
    virtual char *name() { return "Software Packages"; }
    virtual char *group() { return "Package Management"; }
    virtual char *desc() { return "Build and Install Software"; }
    virtual char *credits()
    {
        return ("Robert Lewko <lewkor@mountlinux.com> Mount Linux Inc. ");
    }
    virtual char *version() { return "0.1"; }
    void getFocus();
    void exec(hostObj* myhost, unsigned int mid, moduleList* module);
    void recv(netmessage* remoteMsg, int type);

 private:
    hostObj* host;
    unsigned int moduleID;

    // handle to window
    mod_softwarewin* srcwin;

    // for handling netmessages
    void buildsource(netmessage* msg);
    void configsource(netmessage* msg);
    void expandsource(netmessage* msg);
    void installsource(netmessage* msg);
    void listsource(netmessage* msg);
};

DLC_Register(mod_software);

#endif
