/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mod_software.h
*
*   This class implements the package manager plugin.  The package manager
*   (1) chooses a tar file on the local host, sends it to target, tar expands
*   it and tar's status and output is returned for the user.
*   (2) sends the "./configure" message to the target and returns
*   status and output.
*   (3) sends the "make" message to the target and returns status and output.
*   (4) sends the "make install" message to the target and returns status
*   and output.
*   (5) requests to view installed files for this package.
*****************************************************************************/

#include "mod_software.h"
#include "mod_softwarewin.h"
#include "nmSourceExpand.h"
#include "nmSourceList.h"
#include "nmStrStream.h"

#define DEBUG_MOD_SOFTWARE

mod_software::mod_software()
{
#if defined(DEBUG_MOD_SOFTWARE)
    debug("mod_software::mod_software: in constructor");
#endif
    srcwin = 0;
}

mod_software::~mod_software()
{
#if defined(DEBUG_MOD_SOFTWARE)
    debug("mod_software::~mod_software() destructor");
#endif
    if (srcwin)
    {
#if defined(DEBUG_MOD_SOFTWARE)
        debug("mod_software::~mod_software() deleting srcwin");
#endif
        delete srcwin;
    }
}

void mod_software::getFocus()
{
#if defined(DEBUG_MOD_SOFTWARE)
    debug("mod_software::getFocus() getting focus");
#endif
    srcwin->show();
    srcwin->setActiveWindow();
    srcwin->raise();
}

void mod_software::exec(hostObj* myhost, unsigned int mid, moduleList* module)
{
    nmSourceList* msg;

#if defined(DEBUG_MOD_SOFTWARE)
    debug("\tmod_software::exec: mid=%d", mid);
#endif

    init(myhost, mid, module);

    QWidget* parent = 0;
    const char *name = 0;
    host = myhost;
    moduleID = mid;
    srcwin = new mod_softwarewin(mid, myhost, parent, name);
    srcwin->show();
    msg = new nmSourceList(host->getRawSocket(), moduleID, COMMAND_LISTSRC);
    host->network->queueMessage((netmessage*) msg);
#if defined(DEBUG_MOD_SOFTWARE)
    debug("mod_software::exec: queueMessage(nmSourceList)");
    debug("COMMAND_LISTSRC=%d", COMMAND_LISTSRC);
#endif
}

void mod_software::recv(netmessage* remoteMsg, int type)
{
#if defined(DEBUG_MOD_SOFTWARE)
    debug("mod_software::recv: type=%d", type);
#endif
    switch (type)
    {
    case COMMAND_BUILDSRC:
        buildsource(remoteMsg);
        break;

    case COMMAND_CONFIGSRC:
        configsource(remoteMsg);
        break;

    case COMMAND_EXPANDSRC:
        expandsource(remoteMsg);
        break;

    case COMMAND_INSTALLSRC:
        installsource(remoteMsg);
        break;

    case COMMAND_STRSTREAM:
        listsource(remoteMsg);
        break;

    default:
#if defined(DEBUG_SOURCE)
        debug("mod_software::recv: bad netmessage type");
#endif
        break;
    }
    delete remoteMsg;
}

// build return data
void mod_software::buildsource(netmessage* msg)
{
    //nmSourceBuild* msgptr = (nmSourceBuild*) msg;
#if defined(DEBUG_MOD_SOFTWARE)
    debug("mod_software::buildsourc: not implemented");
#endif
}

// config return data
void mod_software::configsource(netmessage* msg)
{
    //nmSourceConfig* msgptr = (nmSourceConfig*) msg;
#if defined(DEBUG_MOD_SOFTWARE)
    debug("mod_software::configsource: not implemented");
#endif
}

// expand return data
void mod_software::expandsource(netmessage* msg)
{
    nmSourceExpand* msgptr = (nmSourceExpand*) msg;

#if defined(DEBUG_MOD_SOFTWARE)
    debug("mod_software::expandsource: getting response from process");
#endif
    //srcwin->setElapsedTime(msgptr->getElapsedTime());
    srcwin->setFileCount(msgptr->getNumberOfFiles());
    srcwin->setResultFile(msgptr->getFileName());

    delete msg;
}

// install return data
void mod_software::installsource(netmessage* msg)
{
    //nmSourceInstall* msgptr = (nmSourceInstall*) msg;
#if defined(DEBUG_MOD_SOFTWARE)
    debug("mod_software::installsource: not implemented");
#endif
}

// list packages return data
void mod_software::listsource(netmessage* msg)
{
    nmStrStream* ssptr = (nmStrStream*) msg;
    char *pkg;
    unsigned long commid;
    int idx;

    if (ssptr->getSequence() == 0)
    {
#if defined(DEBUG_MOD_SOFTWARE)
        debug("mod_software::listsource: entered");
#endif
        for (idx = 0; idx < ssptr->amtStrs(); idx++)
        {
            pkg = ssptr->getStr(idx);
            srcwin->setSourceView(pkg);
        }
#if defined(DEBUG_MOD_SOFTWARE)
        debug("mod_software::listsource: leaving");
#endif
    }
    else if (ssptr->getSequence() == 1)
    {
        for (idx = 0; ssptr->amtStrs(); idx++)
        {
            srcwin->setInfoFile(ssptr->getStr(idx));
        }
    }
    delete msg;
}
