/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GNU GPL.
*
******************************************************************************/

#ifndef _mod_observer_h
#define _mod_observer_h

#include <qdialog.h>
#include <qlabel.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qlayout.h>

#include "plugin.h"
#include "nmSysInfo.h"
#include "EQDisplay.h"

class mod_observerwin : public QDialog {
    Q_OBJECT
    
    public:
        mod_observerwin( unsigned int newMID, hostObj * thisHost, char * name );
        void closeEvent( QCloseEvent * e );
        virtual ~mod_observerwin();
        EQDisplay * equalizer;
        QLabel * idleData;
        QLabel * sysData;
        QLabel * userData;
        QLabel * niceData;
	QGridLayout * hostLayout;
        
    public slots:
        void getSysInfo();
        
    private:
        unsigned int moduleID;
        hostObj * host;
        netmessage * message;
        bool fetching;     
};

class mod_observer : public plugin {
    public:
        mod_observer();
        virtual ~mod_observer();
    
        // these return info on the plugin in question
		virtual char * name() { return "Observer"; }
		virtual char * group() { return "System"; }
		virtual char * desc() { return "System/Network monitoring plugin."; }
    	virtual char * credits() { return "Sebastien Taylor <sebastien@mountlinux.com> Mount Linux Inc."; }
		virtual char * version() { return "0.1"; }
		
		// for receiving netmessage objects
		virtual void recv(netmessage *, int);
		
	    // to get focus
        virtual void getFocus();
 
		// the "main" function for the plugin
		virtual void exec(hostObj * thisHost, unsigned int MID, moduleList * thisModL);
	
	private:
		mod_observerwin * monitorWin;
		QTimer* timekeeper;
		QString *sysString, *userString, *idleString, *niceString;
		int userTicks, sysTicks, niceTicks, idleTicks;
		int user, sys, nice, idle;
};

DLC_Register(mod_observer); 

#endif // _mod_observer_h
