/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL.
*
******************************************************************************/

#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcolordialog.h>
#include <qnamespace.h>
#include <qtimer.h>

#include "mod_observer.h"
#include "guisocket.h"

mod_observer::mod_observer()
{
    monitorWin = NULL;    
    timekeeper = NULL;
    
    idleString = new QString();
    sysString = new QString();
    userString = new QString();
    niceString = new QString();
}

mod_observer::~mod_observer()
{
    if ( monitorWin != NULL ) { delete monitorWin; }
    if ( timekeeper != NULL ) { delete timekeeper; }
    delete idleString;
    delete sysString;
    delete userString;
    delete niceString;
}

void mod_observer::exec(hostObj * thisHost, unsigned int MID, moduleList * thisModL)
{
    init(thisHost,MID,thisModL);
    monitorWin = new mod_observerwin(moduleID,host,"Observer Module");   
    monitorWin->show();
}

void mod_observer::recv( netmessage * message, int objectID )
{
    debug("recv");
    if (objectID == COMMAND_SYSINFO)
    {
        nmSysInfo* systemload = (nmSysInfo*) message;
    		
    	int totalTicks = ((systemload->user - userTicks) +
	    				  (systemload->sys - sysTicks) +
    					  (systemload->nice - niceTicks) +
    					  (systemload->idle - idleTicks));

    	if (totalTicks > 0)
    	{
    		user = (100 * (systemload->user - userTicks)) / totalTicks;
    		sys = (100 * (systemload->sys - sysTicks)) / totalTicks;
    		nice = (100 * (systemload->nice - niceTicks)) / totalTicks;
    		idle = (100 - (user + sys + nice));
    	}
    	else
    	{    
    		user = sys = nice = idle = 0;
        }
    	userTicks = systemload->user;
    	sysTicks = systemload->sys;
    	niceTicks = systemload->nice;
    	idleTicks = systemload->idle;
            
        if (timekeeper == NULL)
        {
            timekeeper = new QTimer();
            QObject::connect(timekeeper, SIGNAL(timeout()), monitorWin, SLOT(getSysInfo()) );
            timekeeper->start( 1000, FALSE );
        }

        monitorWin->equalizer->setBarValue(0, sys);
        monitorWin->equalizer->setBarValue(1, user);
        
        idleString->truncate(0);
        idleString->setNum(idle);
        monitorWin->idleData->setText(*idleString);
        
        sysString->truncate(0);
        sysString->setNum(sys);
        monitorWin->sysData->setText(*sysString);
        
        userString->truncate(0);
        userString->setNum(user);
        monitorWin->userData->setText(*userString);
        
        niceString->truncate(0);
        niceString->setNum(nice);
        monitorWin->niceData->setText(*niceString);
    }

    delete message;
}
void mod_observer::getFocus()
{
    monitorWin->show();
    monitorWin->setActiveWindow();
    monitorWin->raise();
}

/******************************************
*   
*   This next part is for writing the 
*   interface and most usefull code
*
*******************************************/

mod_observerwin::mod_observerwin( unsigned int newMID, hostObj * thisHost, char * name) 
    : QDialog(0,name)
{
    moduleID = newMID;
    host = thisHost;
    
    setCaption("-=Olympus Observer=-");
   
    hostLayout = new QGridLayout(this,0,0);
    hostLayout->addColSpacing(0, 10);
    hostLayout->addColSpacing(1, 180);
    hostLayout->addColSpacing(2, 10);
    hostLayout->addRowSpacing(0, 10);
    hostLayout->addRowSpacing(1, 130);
    hostLayout->addRowSpacing(2, 10);
    
    QGroupBox * layoutBox = new QGroupBox(*host->getCommonName(), this, "Group Layout Box");
    hostLayout->addWidget(layoutBox,1,1);

    QGridLayout * grid = new QGridLayout(layoutBox,0,0);
    
    grid->addColSpacing( 0, 10 );    
    grid->addColSpacing( 1, 40 );    
    grid->addColSpacing( 2, 10 );   
    grid->addColSpacing( 3, 80 );
    grid->addColSpacing( 4, 10 );
    
    grid->addRowSpacing( 0, 20 );   
    grid->addRowSpacing( 1, 100 );
    grid->addRowSpacing( 2, 10 );

    // The EQBar that will displayed on the left side.
    equalizer = new EQDisplay(layoutBox, 2, 15, 100, 1, 10, "equalizer");
    grid->addWidget(equalizer,1,1);
    
    // Some human readable info will be displayed on the right side.
    QGridLayout * minigrid = new QGridLayout(layoutBox,0,0);
    grid->addLayout(minigrid, 1, 3);
    
    minigrid->addColSpacing(0, 60);
    minigrid->addColSpacing(1, 20);
    
    minigrid->addRowSpacing(0, 15);
    minigrid->addRowSpacing(1, 20);
    minigrid->addRowSpacing(2, 20);
    minigrid->addRowSpacing(3, 20);
    minigrid->addRowSpacing(4, 20);
    minigrid->addRowSpacing(5, 15);
    
    QLabel *idleLabel = new QLabel(layoutBox, "Idle Label");
    idleLabel->setText("CPU Idle: ");
    minigrid->addWidget(idleLabel, 1, 0);

    QLabel *sysLabel = new QLabel(layoutBox, "System Label");
    sysLabel->setText("CPU System: ");   
    minigrid->addWidget(sysLabel, 2, 0);    

    QLabel *userLabel = new QLabel(layoutBox, "User Label");
    userLabel->setText("CPU User: ");
    minigrid->addWidget(userLabel, 3, 0);
    
    QLabel *niceLabel = new QLabel(layoutBox, "Nice Label");
    niceLabel->setText("CPU Nice: ");
    minigrid->addWidget(niceLabel, 4, 0);
    
    idleData = new QLabel(layoutBox, "Idle Data");
    minigrid->addWidget(idleData, 1, 1);
    
    sysData = new QLabel(layoutBox, "System Data");
    minigrid->addWidget(sysData, 2, 1);
    
    userData = new QLabel(layoutBox, "User Data");
    minigrid->addWidget(userData, 3, 1);    
    
    niceData = new QLabel(layoutBox, "Nice Data");
    minigrid->addWidget(niceData, 4, 1);
    
    setMinimumSize(200,150);
    
    getSysInfo();
}

mod_observerwin::~mod_observerwin()
{
    if (host != NULL) { host->network->cancelRequests(moduleID); }
}

void mod_observerwin::getSysInfo()
{
    nmSysInfo * info = new nmSysInfo(host->getRawSocket(), moduleID, 
                                     COMMAND_SYSINFO);
    
    fetching = true;
    host->network->queueMessage(info);
}

void mod_observerwin::closeEvent( QCloseEvent * e )
{
    e->accept();
    client->deleteModule(moduleID);
}
    
