/**********************************************************************

 *********************************************************************/

#include "include/mod_inetdwin.h"
#include "include/mod_inetdlist.h"

#include "hostObj.h"
#include "guisocket.h"

#include <qfile.h>
#include <qlineedit.h>

//#define DEBUG_INETD

mod_inetdwin::mod_inetdwin(unsigned int newMID, hostObj * thisHost, QWidget *parent, const char *name)
              : QDialog(parent, name, false, 688)
{
    moduleID = newMID;
    host = thisHost;
    fetching = false;
    saveThis = false;
    timer = NULL;    
    fileFetchWindow = NULL;
    serviceEditing = NULL;

    ListView = new inetdlist(this, "ListView");
    ListView->setGeometry(5, 35, 160, 420);
    ListView->setSorting(-1,true);
    ListView->addColumn("Entries");
    ListView->setColumnWidth(0,157);
    ListView->setSorting(-1, false);
    ListView->header()->setClickEnabled(false);
    ListView->show();
    QObject::connect(ListView,SIGNAL(currentChanged(QListViewItem *)), this, SLOT(editService(QListViewItem*))); 
    // Create a menubar.
    menuBar = new QMenuBar(this, "menuBar");
    menuBar->setGeometry(1, 0, 700, 22);
    
    fileMenu = new QPopupMenu(this);
    helpMenu = new QPopupMenu(this);
    
    // File menu.
    
    fileMenu->insertItem("&Get Configuration From " + *host->getCommonName(), this, SLOT(getConfig()), CTRL+Key_O);
    fileMenu->insertItem("&Save Configuration To " + *host->getCommonName(), this, SLOT(saveConfig()), CTRL+Key_S); 
    fileMenu->insertSeparator();
    menuItemNewService = fileMenu->insertItem("New Service...", this, SLOT(newService()));
    fileMenu->setItemEnabled(menuItemNewService, false);
    menuItemNewGroup = fileMenu->insertItem("New Group...", this, SLOT(newGroup()));
    fileMenu->setItemEnabled(menuItemNewGroup, false);
    menuItemRename = fileMenu->insertItem("Rename...", this, SLOT(renameItem()));
    fileMenu->setItemEnabled(menuItemRename, false);
    fileMenu->insertSeparator();
    fileMenu->insertItem("&Close", this, SLOT(close()), CTRL+Key_W);
    
 
    // Help Menu.
    helpMenu->insertItem("About", this, SLOT(about()), CTRL+Key_H);
    helpMenu->insertItem("About Qt", this, SLOT(aboutQt()));
    helpMenu->insertItem("Help Window", this, SLOT(helpwindow()));
    
    // Add all items to menubar.
    menuBar->setSeparator( QMenuBar::InWindowsStyle );
    menuBar->insertItem("&Services On Demand Options", fileMenu);
    menuBar->insertSeparator();
    menuBar->insertItem("&Help", helpMenu);
    
    // End of menubar.

    QLabel *ModuleLogo = new QLabel(this, "ModuleLogo");
    ModuleLogo->setGeometry(533, 39, 145, 95);
    QPixmap pixmap;
    pixmap.load("icons/logo.png");
    ModuleLogo->setBackgroundPixmap(pixmap);
    ModuleLogo->setFixedSize(145,95);

    QLabel *nameLabel = new QLabel(this, "nameLabel");
    nameLabel->setGeometry(180, 60, 40, 20);
    nameLabel->setText( "Name:" );

    mod_name = new QLabel(this, "mod_name");
    mod_name->setGeometry(230, 60, 250, 20);
    mod_name->setText( "Services On Demand" );

    QLabel *groupLabel = new QLabel(this, "groupLabel");
    groupLabel->setGeometry(180, 80, 40, 20);
    groupLabel->setText( "Group:" );

    mod_group = new QLabel(this, "mod_group");
    mod_group->setGeometry(230, 80, 250, 20);
    mod_group->setText( "Olympus" );

    QLabel *descLabel = new QLabel(this, "descLabel");
    descLabel->setGeometry(180, 100, 35, 20);
    descLabel->setText( "Desc:" );

    mod_desc = new QLabel(this, "mod_desc");
    mod_desc->setGeometry(230, 100, 300, 20);
    mod_desc->setText( "Configuration of Services on Demand (inetd)" );
   
    // Settings frame used to configure the services.
    QFrame *SettingsFrame = new QFrame(this, "SettingsFrame");
    SettingsFrame->setGeometry(180, 160, 240, 295);
    SettingsFrame->setFrameStyle( 49 );
    SettingsFrame->setLineWidth( 1 );
    SettingsFrame->setMidLineWidth( 0 );
    SettingsFrame->QFrame::setMargin( 0 );

    QLabel *settingsLabel = new QLabel(this, "settingsLabel");
    settingsLabel->setText("Current Settings");
    settingsLabel->setGeometry(200, 153, 
                               settingsLabel->sizeHint().width(), 
                               settingsLabel->sizeHint().height());

    QLabel *stateLabel = new QLabel(this, "statusLabel");
    stateLabel->setGeometry(190, 210, 60, 20);
    stateLabel->setText( "Status:" );

    statusComboBox = new QComboBox(false, this, "statusComboBox");
    statusComboBox->setGeometry(280, 210, 120, 20);
    statusComboBox->insertItem( "Enabled");
    statusComboBox->insertItem( "Disabled");
    QObject::connect(statusComboBox, SIGNAL(activated(int)),
                     this, SLOT(updateService(int)));
                     
    QLabel *socketLabel = new QLabel(this, "socketLabel");
    socketLabel->setGeometry(190, 240, 60, 20);
    socketLabel->setText( "Socket:" );

    socketComboBox = new QComboBox(true, this, "socketComboBox");
    socketComboBox->setGeometry(280, 240, 120, 20);
    socketComboBox->insertItem( "stream" );
    socketComboBox->insertItem( "dgram" );
    socketComboBox->setAutoCompletion(true);
    
    // QT2.1
    //socketComboBox->setDuplicatesEnabled(false);
    
    QLabel *protocolLabel = new QLabel(this, "protocolLabel");
    protocolLabel->setGeometry(190, 270, 60, 20);
    protocolLabel->setText( "Protocol:" );

    protocolComboBox = new QComboBox(true, this, "protocolComboBox");
    protocolComboBox->setGeometry(280, 270, 120, 20);
    protocolComboBox->insertItem( "tcp" );
    protocolComboBox->insertItem( "udp" );
    protocolComboBox->setAutoCompletion(true);
    // QT2.1
    //protocolComboBox->setDuplicatesEnabled(false);

    QLabel *nowaitLabel = new QLabel(this, "nowaitLabel");
    nowaitLabel->setGeometry(190, 300, 60, 20);
    nowaitLabel->setText( "Wait?:" );

    waitComboBox = new QComboBox(false, this, "waitComboBox");
    waitComboBox->setGeometry(280, 300, 120, 20);
    waitComboBox->insertItem( "wait" );
    waitComboBox->insertItem( "nowait" );
    
    QLabel *userLabel = new QLabel(this, "userLabel");
    userLabel->setGeometry(190, 330, 60, 20);
    userLabel->setText( "User:" );

    userComboBox = new QComboBox(true, this, "userComboBox");
    userComboBox->setGeometry(280, 330, 120, 20);
    userComboBox->insertItem( "root" );
    userComboBox->insertItem( "nobody" );
    userComboBox->setAutoCompletion( true );
    
    QLabel *serverLabel = new QLabel(this, "serverLabel");
    serverLabel->setGeometry(190, 360, 60, 20);
    serverLabel->setText( "Server:" );

    serverEdit = new QLineEdit(this, "serverComboBox");
    serverEdit->setGeometry(280, 360, 120, 20);
    
    QLabel *flagsLabel = new QLabel(this, "flagsLabel");
    flagsLabel->setGeometry(190, 390, 60, 20);
    flagsLabel->setText( "Flags:" );

    flagsEdit = new QLineEdit(this, "flagsComboBox");
    flagsEdit->setGeometry(280, 390, 120, 20);

    // Status frame used to display current settings.
    QFrame *StatusFrame = new QFrame(this, "StatusFrame");
    StatusFrame->setGeometry(440, 160, 240, 295);
    StatusFrame->setFrameStyle( 49 );
    StatusFrame->setLineWidth( 1 );
    StatusFrame->setMidLineWidth( 0 );
    StatusFrame->QFrame::setMargin( 0 );

    QLabel *statusLabel = new QLabel(this, "statusLabel");
    statusLabel->setText( "Original Settings" );
    statusLabel->setGeometry(460, 153, 
                             statusLabel->sizeHint().width(), 
                             statusLabel->sizeHint().height());

    QLabel *statusStatusLabel = new QLabel(this, "statusStatusLabel");
    statusStatusLabel->setGeometry(450, 210, 60, 20);
    statusStatusLabel->setText( "State:" );

    statusField = new QLabel(this, "statusField");
    statusField->setGeometry(540, 210, 100, 20);
    statusField->setText( "No Value Found" );

    QLabel *socketStatusLabel = new QLabel(this, "socketStatusLabel");
    socketStatusLabel->setGeometry(450, 240, 60, 20);
    socketStatusLabel->setText( "Socket:" );

    socketField = new QLabel(this, "socketField");
    socketField->setGeometry(540, 240, 100, 20);
    socketField->setText( "No Value Found" );

    QLabel *protocolStatusLabel = new QLabel(this, "protocolStatusLabel");
    protocolStatusLabel->setGeometry(450, 270, 60, 20);
    protocolStatusLabel->setText( "Protocol:" );

    protocolField = new QLabel(this, "protocolField");
    protocolField->setGeometry(540, 270, 100, 20);
    protocolField->setText( "No Value Found" );

    QLabel *waitStatusLabel = new QLabel(this, "waitStatusLabel");
    waitStatusLabel->setGeometry(450, 300, 60, 20);
    waitStatusLabel->setText( "Wait?:" );

    waitField = new QLabel(this, "waitField");
    waitField->setGeometry(540, 300, 100, 20);
    waitField->setText( "No Value Found" );

    QLabel *userStatusLabel = new QLabel(this, "userStatusLabel");
    userStatusLabel->setGeometry(450, 330, 60, 20);
    userStatusLabel->setText( "User:" );

    userField = new QLabel(this, "userField");
    userField->setGeometry(540, 330, 100, 20);
    userField->setText( "No Value Found" );

    QLabel *serverStatusLabel = new QLabel(this, "serverStatusLabel");
    serverStatusLabel->setGeometry(450, 360, 60, 20);
    serverStatusLabel->setText( "Server:" );

    serverField = new QLabel(this, "serverField");
    serverField->setGeometry(540, 360, 100, 20);
    serverField->setText( "No Value Found" );

    QLabel *flagStatusLabel = new QLabel(this, "flagStatusLabel");
    flagStatusLabel->setGeometry(450, 390, 60, 20);
    flagStatusLabel->setText( "Flags:" );

    flagsField = new QLabel(this, "flagsField");
    flagsField->setGeometry(540, 390, 100, 20);
    flagsField->setText( "No Value Found" );

    setFixedSize(700,460);
    setCaption(*host->getCommonName() + ":  Services On Demand");

    enableSettingsMenus(false);
    getConfig();
}

void mod_inetdwin::closeEvent( QCloseEvent * e )
{
    if (! saveThis) 
    { 
        e->accept();   
        client->deleteModule(moduleID);
        return;
    }
    
    int choice;
    choice = QMessageBox::critical(0,"Getting Ready to Exit Mod Inetd", 
    "Would you like to sync your changes 
with the server before exiting?

If you choose no all changes will be lost!",
                          "Yes", "No", "Cancel", 0, 2);
    if (choice == 0) 
    { 
        #ifdef DEBUG_MODINETD
            debug("\tMod Inetd >> Exiting with sync."); 
        #endif
        saveConfig();
        QObject::connect(host->network, SIGNAL(messageSent(unsigned long)),
                         this, SLOT(goodbye()));
        e->ignore();
    }
    else if (choice == 1) 
    { 
        #ifdef DEBUG_MODINETD
            debug("Mod Inetd >> Exiting without sync. "); 
        #endif
        e->accept();   
        client->deleteModule(moduleID);
    }
    else 
    { 
        #ifdef DEBUG_MODINETD
            debug("Mod Inetd >> Cancelled exit operation."); 
        #endif
        e->ignore();
    }
}

int mod_inetdwin::getIndex(QString text,  QComboBox *box)
{
    #ifdef DEBUG_INETD
        debug("getIndex()");
    #endif
    int count = box->count() - 1;

    for (count = 0; count < box->count(); count++)
    {
        #ifdef DEBUG_INETD
            debug("comparing %s with %s", text.data(), box->text(count).data());
        #endif
        if (box->text(count) == text)
        {
            return count;
        }
    }
    #ifdef DEBUG_INETD
        debug("done...");
    #endif
    
    box->insertItem(text);
    return box->count() - 1;

}        

void mod_inetdwin::prepForEdit()
{
    fileMenu->setItemEnabled(menuItemNewService, true);
    fileMenu->setItemEnabled(menuItemNewGroup, true);
}

void mod_inetdwin::denyEdit()
{
    fileMenu->setItemEnabled(menuItemNewService, false);
    fileMenu->setItemEnabled(menuItemNewGroup, false);
}

mod_inetdwin::~mod_inetdwin()
{
    if (tempSendFile.length() > 1 && QFile::exists(tempSendFile)) { unlink(tempSendFile.data()); }
    if (tempGetFile.length() > 1 && QFile::exists(tempGetFile)) { unlink(tempGetFile.data()); }
    
}
