
#include "include/mod_inetdwin.h"
#include "include/mod_inetdlist.h"

#include "hostObj.h"
#include "guisocket.h"
#include "icons.h"
#include "nmFetchConfig.h"
#include "nmUpdateConfig.h"
#include "nmExec.h"

#include <qfile.h>
#include <qlineedit.h>

#define DEBUG_SLOTS

void mod_inetdwin::notimplemented()
{
    QMessageBox::warning(0,"Error", "Sorry, this feature has not yet been implemented.
If you would like to help create it please contact me
and explain which feature you would like to code.
    
    - Sebastien Taylor <sebastien@mountlinux.com>");
}

void mod_inetdwin::about()
{
    QMessageBox::about(0,"About Inetd", "Inetd controls many services on a Linux System
and this tool is right there to help you admin it.
If you don't know what you are doing you should
use the wizard(not here yet).");
}

void mod_inetdwin::aboutQt()
{
    QMessageBox::aboutQt(0,NULL);
}

void mod_inetdwin::helpwindow()
{
    QMessageBox::warning(0,"HELP ME?!?", "Yes, you do need help.");
}

void mod_inetdwin::close()
{
    closeEvent(new QCloseEvent);
}

void mod_inetdwin::configureModule()
{
    QMessageBox::warning(0,"Configure Module", "Not Yet Implemented!!!!!");
}

void mod_inetdwin::enableSettingsMenus(bool onOrOff)
{
    statusComboBox->setEnabled(onOrOff);
    socketComboBox->setEnabled(onOrOff);
    protocolComboBox->setEnabled(onOrOff);
    waitComboBox->setEnabled(onOrOff);
    userComboBox->setEnabled(onOrOff);
    serverEdit->setEnabled(onOrOff);
    flagsEdit->setEnabled(onOrOff);
    #ifdef DEBUG_SLOTS
        debug("Done enableSettingsMenus");
    #endif
}

void mod_inetdwin::getConfig()
{
    #ifdef DEBUG_SLOTS
        debug("\nmod_inetdwin::getConfig() >>  getting configuration");
    #endif
    
    if (fetching == true) 
    { 
        #ifdef DEBUG_SLOTS
            debug("mod_inetdwin::getConfig() >>  already waiting, returning now\n");
        #endif
        return; 
    }
    
    nmFetchConfig* getConf; 
    getConf = new nmFetchConfig("inetd", "config", host->getRawSocket(),moduleID,
                                 COMMAND_FETCHCONFIG);
    
    #ifdef DEBUG_SLOTS
        debug("mod_inetdwin::getConfig() >>  setting up timer");
    #endif
    
    denyEdit();
    fetching = true;
    host->network->queueMessage(getConf);
    timer = new QTimer(this);
    QObject::connect(timer, SIGNAL(timeout()), this, SLOT(connectionKilled()));
    timer->start(10000, true);
    
    #ifdef DEBUG_SLOTS
        debug("mod_inetdwin::getConfig() >>  finished putting our request\n");
    #endif
}

void mod_inetdwin::connectionKilled()
{
    if (timer != NULL) { delete timer; timer = NULL; }
    fileFetchWindow = new QDialog(this, "Fetching", true);
    fetching = false;
    host->network->cancelRequests(moduleID);
    QMessageBox::critical(0,"Timeout Error", "Time expired and we did not get any configuration data.");
}

void mod_inetdwin::newGroup()
{
    #ifdef DEBUG_SLOTS
        debug("Creating a new Group");
    #endif
    if (lastGroupAdded == NULL) { groupsItem = new groups(ListView); }
    else { groupsItem = new groups(ListView, (QListViewItem*) lastGroupAdded); }
    lastGroupAdded = groupsItem;
    groupsItem->setText(0,"New Group");
    groupsItem->setExpandable(true);
    groupsItem->setComment("#:New Group:");  
}

void mod_inetdwin::newService()
{
    #ifdef DEBUG_SLOTS
        debug("Creating a new Service");
    #endif
    int count;
    QListViewItem * moveTo = ListView->selectedItem();
    QListViewItem * lastItem = NULL;
    if (moveTo == NULL) { moveTo = lastGroupAdded; }
    else if (moveTo->depth() > 0) { moveTo = moveTo->parent(); }
    moveTo->setOpen(true);
    
    if ((lastItem = moveTo->firstChild()) > 0 ) 
    {
        for ( count = 1 ; count < moveTo->childCount() ; count++)
        {
            lastItem = lastItem->nextSibling();
        }

        debug("putting it after %s", lastItem->text(0).data());
        serviceItem = new service((groups*)moveTo, lastItem);
    }
    else { serviceItem = new service((groups*)moveTo); }
    
    lastItemAdded = serviceItem;
    serviceItem->setPixmap(0,*icon_small->find("xmark"));
    serviceItem->setText(0,"New Item");
    serviceItem->setName("New Item");
    debug("finished adding new item\n");
}

void mod_inetdwin::saveConfig()
{
    int countGroups, count;
    service * thisService;
    groups * thisGroup = (groups*) ListView->firstChild();
    
    editService(ListView->selectedItem());
    denyEdit();
    #ifdef DEBUG_SLOTS
        debug("done denying about to if tempSendFile");
    #endif
    if (tempSendFile.length() > 1)
    {
        if (QFile::exists(tempSendFile)) { unlink(tempSendFile.data()); }
        tempSendFile.truncate(0);
    }

    int fileDesc = client->makeTempFile(&tempSendFile);
    QFile* output = new QFile(tempSendFile);    
   ::close(fileDesc);
    #ifdef DEBUG_SLOTS 
        debug("Done closing FileDesc");
    #endif
    
    if (QFile::exists(tempSendFile) && output->open(IO_WriteOnly))
    {
        QTextStream outputStream(output);
        
        if ((thisGroup = (groups*) ListView->firstChild()) > 0)
        {
            debug("\n\nchild count is: %i", ListView->childCount());
            for (countGroups = 0; countGroups < ListView->childCount(); countGroups++)
            {
                if (thisGroup->getComment() != NULL &&
                    ! thisGroup->getComment()->isNull()) { outputStream << *thisGroup->getComment(); debug("s",thisGroup->getComment()->data());}
            
            debug("whazzup");
                if ((thisService = (service*) thisGroup->firstChild()) > 0)
                {
                    for (count = 0; count < thisGroup->childCount(); count++)
                    {
                        outputStream << thisService->getLine();
                        debug("%s", thisService->getLine());
                        thisService = (service*) thisService->nextSibling();
                    }
                }
                
                thisGroup = (groups*) thisGroup->nextSibling();
            }
        }

        output->close();
        
        if (output->size() > 0)
        {
            // send the update
            nmUpdateConfig* newConfig = new nmUpdateConfig("inetd", "config", (char*) tempSendFile.data(), 
                                                        host->getRawSocket(), moduleID, COMMAND_UPDATECONFIG);
            host->network->queueMessage(newConfig);
        
            nmExec* restartInetd = new nmExec("inetd", "restart", host->getRawSocket(), moduleID, COMMAND_EXEC);
            host->network->queueMessage(restartInetd);
        
            QObject::connect(host->network, SIGNAL(messageSent(unsigned long)),
                             this, SLOT(configUpdated(unsigned long)));
        }
    }
    
    delete output;
}

void mod_inetdwin::configUpdated(unsigned long mid)
{
    if (mid == moduleID)
    {
        prepForEdit();
        QObject::disconnect(host->network, SIGNAL(messageSent(unsigned long)),
                            this, SLOT(configUpdated(unsigned long)));
        
        if (tempSendFile.length() > 1)
        {
            if (QFile::exists(tempSendFile)) { unlink(tempSendFile.data()); }
            tempSendFile.truncate(0);
        }
        
        saveThis = false;
        QMessageBox::information(0, "Success", "Configuration Updated Successfully");
    }
}

void mod_inetdwin::editService(QListViewItem* myItem)
{
    #ifdef DEBUG_SLOTS
        debug("\nmod_inetd::editService >>  Now in the edit slot");
    #endif
    
    if (serviceEditing != NULL)
    {
        #ifdef DEGUB_SLOTS
            debug("service was found to be valid.");
        #endif
        serviceEditing->setSocket(socketComboBox->currentText());
        serviceEditing->setUser(userComboBox->currentText());
        serviceEditing->setProgram(serverEdit->text());
        serviceEditing->setArgs(flagsEdit->text());
        updateWait(waitComboBox->currentItem(), serviceEditing);
        saveThis = true;
    }
    #ifdef DEBUG_SLOTS
        debug("done.");
    #endif
    
    if (ListView->isDragging()) { return; }
    
    if (myItem == NULL) 
    {
        serviceEditing = NULL;
        fileMenu->setItemEnabled(menuItemRename, false);
        enableSettingsMenus(false); 
        return; 
    }
    
    #ifdef DEBUG_SLOTS
        debug("checking myItem which is %s", myItem->text(0).data());
    #endif
    
    if (myItem->isExpandable())
    {
        #ifdef DEBUG_SLOTS
            debug("Looks like this was a group");
        #endif
        serviceEditing = NULL;
        fileMenu->setItemEnabled(menuItemRename, true);
        enableSettingsMenus(false); 
        return;
    }
    else
    {
        #ifdef DEBUG_SLOTS
            debug("Looks like this was a serviceItem");
        #endif
        service * thisService = (service*) myItem;
        
        fileMenu->setItemEnabled(menuItemRename, true);
        serviceEditing = thisService;
        mod_name->setText(thisService->getName());
        mod_group->setText("Inetd!");
        mod_desc->setText("This will check /etc/services to get it's stuff");
        
        if (thisService->getStatus()) { statusComboBox->setCurrentItem(0); }
        else { statusComboBox->setCurrentItem(1); }
        if (thisService->getorigStatus()) { statusField->setText("Enabled"); }
        else { statusField->setText("Disabled"); }
     
        socketComboBox->setCurrentItem(getIndex(thisService->getSocket(), socketComboBox));
        if (thisService->getorigSocket().isNull()) { socketField->setText(""); }
        else { socketField->setText(thisService->getorigSocket()); }
        
        protocolComboBox->setCurrentItem(getIndex(thisService->getProtocol(), protocolComboBox));        
        if (thisService->getorigProtocol().isNull()) { protocolField->setText(""); }
        else { protocolField->setText(thisService->getorigProtocol()); }
        
        if(thisService->getWait()) { waitComboBox->setCurrentItem(0); }
        else { waitComboBox->setCurrentItem(1); }
        if (thisService->getorigWait()) { waitField->setText("wait"); }
        else { waitField->setText("nowait"); }
        
        userComboBox->setCurrentItem(getIndex(thisService->getUser(), userComboBox));        
        if (thisService->getorigUser().isNull()) { userField->setText(""); }
        else { userField->setText(thisService->getorigUser()); }

        serverEdit->setText(thisService->getProgram());        
        if (thisService->getorigProgram().isNull()) { serverField->setText(""); }    
        else { serverField->setText(thisService->getorigProgram()); }

        flagsEdit->setText(thisService->getArgs());        
        if (thisService->getorigArgs().isNull()) { flagsField->setText(""); }    
        else { flagsField->setText(thisService->getorigArgs()); }
        
        enableSettingsMenus(true); 
        
        return;
    }
    
    #ifdef DEBUG_SLOTS
        debug("mod_inetd::editService >>  Now out of the edit slot\n");
    #endif
}

void mod_inetdwin::updateService(int state)
{
    service* thisService = (service*) ListView->selectedItem();
    
    if (state == 1)
    {
        #ifdef DEBUG_SLOTS
            debug("Disabling service");
        #endif
        thisService->setStatus(false);
    }
    else
    {
        #ifdef DEBUG_SLOTS
            debug("Enabling service");
        #endif
        thisService->setStatus(true);
    }
}

void mod_inetdwin::updateWait(int wait, service* thisService)
{
    if (wait == 0)
    {
        #ifdef DEBUG_SLOTS
            debug("setting to wait");
        #endif
        thisService->setWait(true);
    }
    else
    {
        #ifdef DEBUG_SLOTS
            debug("setting to nowait");
        #endif
        thisService->setWait(false);
    }
}

void mod_inetdwin::renameItem()
{
    QListViewItem* thisItem = ListView->selectedItem();
    if (thisItem == NULL) { return; }
    
    QDialog* renameWindow =  new QDialog(this, "renameWindow", true);
    renameWindow->setCaption("Rename...");
    
    QWidget* layoutWidget = new QWidget(renameWindow);
    QGridLayout* layout = new QGridLayout(layoutWidget, 4, 6);
    QLabel* newNameLabel =  new QLabel(layoutWidget);
    newNameLabel->setText("New name for " + thisItem->text(0));
    
    QLineEdit* newName = new QLineEdit(layoutWidget);
    newName->setText(thisItem->text(0));
    
    QPushButton* okButton = new QPushButton(layoutWidget,"okButton");
    okButton->setText("Ok");
    QObject::connect(okButton, SIGNAL(clicked()), renameWindow, SLOT(accept()));
    
    QPushButton* cancelButton = new QPushButton(layoutWidget,"cancelButton");
    cancelButton->setText("Cancel");
    QObject::connect(cancelButton, SIGNAL(clicked()), renameWindow, SLOT(reject()));
    
    
    layout->addColSpacing(0,10);
    layout->addColSpacing(1,30);
    layout->addColSpacing(2,30);
    layout->addColSpacing(3,10);
    layout->addRowSpacing(0,10);
    layout->addRowSpacing(3,5);
    layout->addRowSpacing(5,10);
 
    layout->addMultiCellWidget(newNameLabel,1,1,1,2);
    layout->addMultiCellWidget(newName,2,2,1,2);
    layout->addWidget(okButton,4,1);
    layout->addWidget(cancelButton,4,2);
    
    layoutWidget->setFixedSize(layout->sizeHint());
    renameWindow->setFixedSize(layout->sizeHint());
    
    if (renameWindow->exec())
    {
        thisItem->setText(0,newName->text());    
        
        if (thisItem->depth() == 1)
        {
            service* thisService = (service*) thisItem;
            thisService->setName(newName->text());
        }
        else
        {
            groups* thisGroup = (groups*) thisItem;
            thisGroup->rename(newName->text());
        }
    }
    
    delete renameWindow;
}
