#include "include/mod_inetdwin.h"
#include "include/mod_inetdlist.h"
#include "regexx.hh"
using namespace regexx;

#include <qfile.h>

#define DEBUG_INETD_PARSER

void mod_inetdwin::parser()
{
    #ifdef DEBUG_INETD_PARSER
        debug("mod_inetd::parser() >>  Opened parser...");
    #endif
    
    if (!QFile::exists(tempGetFile)) { return; }
    
    QFile * thisFile = new QFile(tempGetFile);
    if (thisFile->size() < 1) { delete thisFile; return; }
    if (! thisFile->open(IO_ReadOnly)) { delete thisFile; return; }    
    
    ListView->clear();
    
    Regexx *rexx = new Regexx;
    QString groupName;
    int groupCount = 0;
    bool firstService = true;
    bool debian = false;
    bool lastItemWasService = false;
        // This is for RedHat and other non standard inetd.conf
        // configurations that don't use a nice grouping system.
    
    const char * serviceLine = "^([#]?)([a-zA-Z0-9\\-]+)[[:space:]]*([a-zA-Z0-9]+)[[:space:]]*([a-zA-Z0-9]+)[[:space:]]*(wait|nowait)[[:space:]]*([a-zA-Z0-9\\.]+)[[:space:]]*([a-zA-Z0-9\\/\\.\\-]+)[[:space:]]*(.*)";
    const char * groupLine_debian = "^[#]?[[:space:]]*[a-zA-Z0-9[:space:]]*[\\:]+([[:space:]a-zA-Z0-9\\-]+)[\\:]+[.]*";
    QString buffer;
    lastItemAdded = NULL;
    lastGroupAdded = NULL;
    QTextStream * ifs = new QTextStream(thisFile);
        
    groupsItem = new groups(ListView);
    lastGroupAdded = groupsItem;
    groupsItem->setText(0,"Inetd Config");
    groupsItem->setExpandable(true);
    groupsItem->setOpen(true);
        
    while (!ifs->atEnd())
    {
        buffer.truncate(0);
        buffer.append(ifs->readLine());
        rexx->str("");

            
        if (rexx->exec(buffer.data(), serviceLine))
        {
            if (!debian && firstService)
            {
                if (lastGroupAdded == NULL) { groupsItem = new groups(ListView); }
                else { groupsItem = new groups(ListView, (QListViewItem*) lastGroupAdded); }

                lastGroupAdded = groupsItem;
                groupName.truncate(0);
                groupName.append("Group ");
                groupName.append(QString::number(++groupCount));
                groupsItem->setText(0,groupName);
                groupsItem->setExpandable(true);
                firstService = false;
                groupsItem->rename(groupName);
            }
            if (lastItemAdded == NULL) { serviceItem = new service(lastGroupAdded); }
            else { serviceItem = new service(lastGroupAdded,lastItemAdded); }
                        
            lastItemAdded = serviceItem;
                    
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  Parser found this to be valid=> %s",buffer.data());
            #endif
                 
            if (!((rexx->match[0].atom[0].str().length()) == 0))
            {
                #ifdef DEBUG_INETD_PARSER
                    debug("mod_inetd::parser() >>  Parser making status true");
                #endif
                serviceItem->setStatus(false);
                serviceItem->setOrigStatus(false);
            }
            else
            {
                #ifdef DEBUG_INETD_PARSER
                    debug("mod_inetd::parser() >>  Parser making status true");
                #endif
                serviceItem->setStatus(true);
                serviceItem->setOrigStatus(true);
            }
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  Parser setting name to  %s",rexx->match[0].atom[1].str().c_str());
            #endif
            serviceItem->setName(rexx->match[0].atom[1].str().c_str());
            serviceItem->setOrigName(rexx->match[0].atom[1].str().c_str());
            serviceItem->setText(0,rexx->match[0].atom[1].str().c_str());
                  
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  Parser setting socket to %s",rexx->match[0].atom[2].str().c_str());
            #endif
            serviceItem->setSocket(rexx->match[0].atom[2].str().c_str());
            serviceItem->setOrigSocket(rexx->match[0].atom[2].str().c_str());
                 
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  Parser setting protocol to %s",rexx->match[0].atom[3].str().c_str());
            #endif
            serviceItem->setProtocol(rexx->match[0].atom[3].str().c_str());
            serviceItem->setOrigProtocol(rexx->match[0].atom[3].str().c_str());
                   
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  Parser atom[4]=> %s",rexx->match[0].atom[4].str().c_str());
            #endif
            if ((rexx->match[0].atom[4].str().c_str()[0]) == 'w')
            {
                #ifdef DEBUG_INETD_PARSER
                    debug("mod_inetd::parser() >>  Parser setting wait to true");
                #endif
                serviceItem->setWait(true);
                serviceItem->setOrigWait(true);
            }
            else
            {
                #ifdef DEBUG_INETD_PARSER
                    debug("mod_inetd::parser() >>  Parser setting wait to false");
                #endif
                serviceItem->setWait(false);
                serviceItem->setOrigWait(false);
            }

            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  Parser setting user to %s",rexx->match[0].atom[5].str().c_str());
            #endif
            serviceItem->setUser(rexx->match[0].atom[5].str().c_str());
            serviceItem->setOrigUser(rexx->match[0].atom[5].str().c_str());
              
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  Parser setting program to %s",rexx->match[0].atom[6].str().c_str());
            #endif
            serviceItem->setProgram(rexx->match[0].atom[6].str().c_str());
            serviceItem->setOrigProgram(rexx->match[0].atom[6].str().c_str());
               
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  Parser setting args to %s",rexx->match[0].atom[7].str().c_str());
            #endif
            serviceItem->setArgs(rexx->match[0].atom[7].str().c_str());
            serviceItem->setOrigArgs(rexx->match[0].atom[7].str().c_str());
            lastItemWasService = true;
        }
        else if(rexx->exec(buffer.data(),groupLine_debian))
        {
            lastItemWasService = false;
            debian = true;
            //Add group
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  New Group=> %s",rexx->match[0].atom[0].str().c_str());
            #endif
            if (lastGroupAdded != NULL) { groupsItem = new groups(ListView, (QListViewItem*) lastGroupAdded); }
            else { groupsItem = new groups(ListView); }

            lastGroupAdded = groupsItem;
            groupsItem->setText(0,rexx->match[0].atom[0].str().c_str());
            groupsItem->setExpandable(true);
            groupsItem->setComment(buffer.data());
        }
        else
        {
            if (!debian && lastItemWasService)
            {
                if (lastGroupAdded == NULL) { groupsItem = new groups(ListView); }
                else { groupsItem = new groups(ListView, (QListViewItem*) lastGroupAdded); }

                lastGroupAdded = groupsItem;
                groupName.truncate(0);
                groupName.append("Group ");
                groupName.append(QString::number(++groupCount));
                groupsItem->setText(0,groupName);
                groupsItem->setExpandable(true);
                groupsItem->rename(groupName);
            }
                                                                                                                        
            lastItemWasService = false;
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  Parser found line to be a comment=> %s\n",buffer.data());
            #endif
            lastGroupAdded->setComment(buffer.data());
            #ifdef DEBUG_INETD_PARSER
                debug("mod_inetd::parser() >>  This is what is in the current QString=> %s", lastGroupAdded->getComment());
            #endif
        }
    }
    
    
    #ifdef DEBUG_INETD_PARSER
        debug("mod_inetd::parser() >>  Parsing complete, cleaning up");
    #endif
    thisFile->close();
    delete thisFile;
    delete ifs;
    delete rexx;
    #ifdef DEBUG_INETD_PARSER
        debug("mod_inetd::parser() >>  Exiting Parser");
    #endif
}
