#include "include/mod_inetdlist.h"
#include "include/mod_inetdwin.h"
#include "icons.h"
#include "regexx.hh"
using namespace regexx;

#include <qapplication.h>

/**********************
    inetdlist
 **********************/

inetdlist::inetdlist(QWidget* parent, char* name) : QListView(parent, name) 
{
    scrollTimer = NULL;
    dragging = false;
    openAll = true;
    draggingItem = NULL;
    
    QObject::connect(this, SIGNAL(doubleClicked(QListViewItem *)),
                     this, SLOT(onDoubleClick(QListViewItem *)));
}

void inetdlist::wheelEvent(QWheelEvent * mouseEvent)
{
    if (mouseEvent->delta() > 0)
    {
        scrollUp();
    }
    else if (mouseEvent->delta() < 0)
    {
        scrollDown();   
    }
}

void inetdlist::onDoubleClick(QListViewItem * item) 
{
    // open all items if first item is double clicked
    if (item == firstChild())
    {
        int i;
        for (i = 0; i < childCount(); i++)
        {
            item->setOpen(openAll);
            item = item->nextSibling();
        }
        openAll = ! openAll;
    }
    
    if (item == NULL || item->depth() < 1) { return; }
    
    service* thisService = (service*) item;
    thisService->flipState();
    ((mod_inetdwin*)parent())->editService(thisService);
}

void inetdlist::contentsMouseMoveEvent(QMouseEvent * mouseEvent)
{
    QListViewItem * itemClicked = itemAt(contentsToViewport(mouseEvent->pos()));
    
    if (itemClicked == NULL) 
    { 
        return;
    }
    
    if (mouseEvent->state() & LeftButton && !dragging && !itemClicked->isExpandable())
    {
        QPixmap itemIcon;
        icon_small->find("olympus-defaultItem",itemIcon);
        
        dragging = true;
        draggingItem = itemClicked;
        QApplication::setOverrideCursor(QCursor(itemIcon));
    }
    else if (dragging &&
            (contentsToViewport(mouseEvent->pos()).x() >= 0) && 
            (contentsToViewport(mouseEvent->pos()).x() <= visibleWidth()))
    {
        setCurrentItem(itemClicked);
    }
    
    
    /* Set up a timer to scroll the view if necessary */
    if (contentsToViewport(mouseEvent->pos()).y() < 0) 
    {
        if (scrollTimer == NULL) 
        {
            scrollTimer = new QTimer();
            QObject::connect(scrollTimer, SIGNAL(timeout()), this, SLOT(scrollUp()));
            scrollTimer->start(25);
        }
    } 
    else if (contentsToViewport(mouseEvent->pos()).y() > visibleHeight()) 
    { 
        if (scrollTimer == NULL) 
        {
            scrollTimer = new QTimer();
            QObject::connect(scrollTimer, SIGNAL(timeout()), 
            this, SLOT(scrollDown()));
            scrollTimer->start(25);
        }
    }
    else if (scrollTimer != NULL) 
    {
        delete scrollTimer;
        scrollTimer = NULL;
    }
}

void inetdlist::contentsMouseReleaseEvent(QMouseEvent *mouseEvent)
{
    QListViewItem *itemClicked = itemAt(contentsToViewport(mouseEvent->pos()));

    // Reset any scrolling timers that might exist
    if (scrollTimer != NULL) 
    {
        delete scrollTimer;
        scrollTimer = NULL;
    }
    
    if (dragging)
    {
        
        dragging = false;
        
        QApplication::restoreOverrideCursor();
        
        if (draggingItem == NULL) { return; }
        
        if ((contentsToViewport(mouseEvent->pos()).x() >= 0) && 
            (contentsToViewport(mouseEvent->pos()).x() <= visibleWidth()) &&
            (contentsToViewport(mouseEvent->pos()).y() >= 0) &&
            (contentsToViewport(mouseEvent->pos()).y() <= visibleHeight()))
             { draggingItem = moveItemTo(itemClicked); } 
        else { QApplication::beep(); }   
        
        ensureItemVisible(draggingItem);
        setSelected(draggingItem, true);
        draggingItem = NULL;
    }
}

QListViewItem* inetdlist::moveItemTo(QListViewItem* moveTo)
{
    if (moveTo->depth() > 0) { moveTo = moveTo->parent(); }
    
    if (draggingItem->parent() != moveTo)
    {
        service* newService;
    
        debug("moveItemTo: 1");
        service* thisService = (service*) draggingItem;
        newService = new service((groups*)moveTo);
        debug("moveItemTo: 2");
        
        newService->setText(0,thisService->getName());
        newService->setStatus(thisService->getStatus());
        newService->setName(thisService->getName());
        newService->setSocket(thisService->getSocket());
        newService->setProtocol(thisService->getProtocol());
        newService->setWait(thisService->getWait());
        newService->setUser(thisService->getUser());
        newService->setProgram(thisService->getProgram());
        newService->setArgs(thisService->getArgs());
        
        newService->setOrigStatus(thisService->getorigStatus());
        newService->setOrigName(thisService->getorigName());
        newService->setOrigSocket(thisService->getorigSocket());
        newService->setOrigProtocol(thisService->getorigProtocol());
        newService->setOrigWait(thisService->getorigWait());
        newService->setOrigUser(thisService->getorigUser());
        newService->setOrigProgram(thisService->getorigProgram());
        newService->setOrigArgs(thisService->getorigArgs());
         
         debug("moveItemTo: 3");
        delete thisService;
        debug("moveItemTo: 4");
        return newService;
    }
    else { return draggingItem; }
}


/**********************
    groups
 **********************/

groups::groups(QListView * newListView, QListViewItem * myItem):QListViewItem(newListView, myItem) 
{ 
    comments = new QString(); 
}

groups::groups(QListView * newListView):QListViewItem(newListView) 
{ 
    comments = new QString(); 
}

void groups::setComment(const char * Comment)
{
    debug("we need to add: %s", Comment);
    if(comments != NULL)
    {
        debug("merely appending comment");
        comments->append(Comment);
        comments->append('\n');
    }
    else
    {
        debug("creating new comments object and appending");
        comments = new QString(Comment);
        comments->append('\n');
    }
}

void groups::rename(QString name)
{
    Regexx *rexx = new Regexx;
    const char * groupName = "^(.*)\\:+[[:space:]a-zA-Z0-9\\-]+\\:";
    string replacement, currentComments;
    
    if (comments == NULL) { comments = new QString(); };
    currentComments.append(comments->data());

    replacement.append("%0:").append(name.data()).append(":");
   
    if (rexx->exec(currentComments, groupName)) 
    { 
        comments->truncate(0);
        comments->append(rexx->replace(currentComments, groupName, replacement.c_str()).c_str()); 
    }
    else { comments->prepend("#:" + name + ":\n"); }

    delete rexx;
    return;
}

/**********************
    service
 **********************/
service::service(groups * newGroup):
    QListViewItem((QListViewItem*)newGroup) 
{
    setStatus(false);
    setSocket("stream");
    setProtocol("tcp");
    setWait(false);
    setUser("nobody");
}

service::service(groups * newGroup, QListViewItem * myItem)
    :QListViewItem((QListViewItem*)newGroup,(QListViewItem*) myItem)
{
    setStatus(false);
    setSocket("stream");
    setProtocol("tcp");
    setWait(false);
    setUser("nobody");
}

const char * service::getLine()
{
    QString * line;
    if (status)
    {
        line = new QString("");
    }
    else
    {
        line = new QString("#");
    }
    line->append(name);
    line->append("\t");
    line->append(inetsocket);
    line->append("\t");
    line->append(protocol);
    line->append("\t");
    if (wait)
    {
        line->append("wait");
    }
    else
    {
        line->append("nowait");
    }
    line->append("\t");
    line->append(user);
    line->append("\t");
    line->append(program);
    line->append(" ");
    line->append(args);
    line->append('\n');
    return line->latin1();
}

void service::setStatus(bool Status) 
{ 
    status = Status;
    if (status) { setPixmap(0, *icon_small->find("checkmark")); }
    else { setPixmap(0, *icon_small->find("xmark")); }
}

void service::flipState()
{
    if (status) 
    {
        status = false;
        setPixmap(0, *icon_small->find("xmark")); 
    }
    else 
    { 
        status = true;
        setPixmap(0, *icon_small->find("checkmark")); 
    }
}

void service::setName(QString Name) 
{ 
    name.truncate(0);
    name.append(Name);
}

void service::setSocket(QString Inetsocket) 
{ 
    inetsocket.truncate(0);
    inetsocket.append(Inetsocket);
}

void service::setProtocol(QString Protocol) 
{ 
    protocol.truncate(0);
    protocol.append(Protocol);
}

void service::setWait(bool Wait) 
{ 
    wait = Wait; 
}

void service::setUser(QString User) 
{ 
    user.truncate(0);
    user.append(User);
}

void service::setProgram(QString Program) 
{ 
    program.truncate(0);
    program.append(Program);
}

void service::setArgs(QString Args) 
{ 
    args.truncate(0);
    args.append(Args);
}

void service::setOrigStatus(bool Status) 
{ 
    origstatus = Status;
}

void service::setOrigName(QString Name) 
{ 
    origname.truncate(0);
    origname.append(Name);
}

void service::setOrigSocket(QString Inetsocket) 
{ 
    originetsocket.truncate(0);
    originetsocket.append(Inetsocket);
}

void service::setOrigProtocol(QString Protocol) 
{ 
    origprotocol.truncate(0);
    origprotocol.append(Protocol);
}

void service::setOrigWait(bool Wait) 
{ 
    origwait = Wait; 
}

void service::setOrigUser(QString User) 
{ 
    origuser.truncate(0);
    origuser.append(User);
}

void service::setOrigProgram(QString Program) 
{ 
    origprogram.truncate(0);
    origprogram.append(Program);
}

void service::setOrigArgs(QString Args) 
{ 
    origargs = Args; 
}

