#include "include/mod_inetd.h"
#include "include/mod_inetdwin.h"

#include "nmFetchConfig.h"

#include <qfile.h>
#include <qtimer.h>

mod_inetd::mod_inetd()
{
        #ifdef DEBUG_INETD
            debug("\tMod_inetd >> opening");
        #endif   
        inetdWin = NULL;
        host = NULL;
}

// Used to recieve netmessages.
void mod_inetd::recv(netmessage * message, int objectID) 
{ 
    if (objectID == COMMAND_FETCHCONFIG)
    {
        if (inetdWin->fileFetchWindow != NULL) { delete inetdWin->fileFetchWindow; inetdWin->fileFetchWindow = NULL; }
        if (inetdWin->timer != NULL) { delete inetdWin->timer; inetdWin->timer = NULL; }
        nmFetchConfig* fileFetcher = (nmFetchConfig*) message;
        
        if (inetdWin->tempGetFile.length() > 0) 
        { 
            if (QFile::exists(inetdWin->tempGetFile)) { unlink(inetdWin->tempGetFile.data()); }
            inetdWin->tempGetFile.truncate(0);
        }
        
        inetdWin->tempGetFile.append(fileFetcher->configData());
        inetdWin->fetching = false;
        inetdWin->parser();
        inetdWin->prepForEdit();
        
        delete fileFetcher;
    }
    else if (objectID > COMMAND_ERROR && objectID < 200)
    {
        // Will change this to a popup box
        cerr << "An error occured..." << endl;
        delete message;
    }
    else { delete message; }
}

// This is the plugin's main function.
void mod_inetd::exec(hostObj * thisHost, unsigned int MID, moduleList * thisModL)
{
    // This is very important
    init(thisHost, MID, thisModL);
    #ifdef DEBUG_INETD
        debug("\tMod_inetd >> my MID is %i", moduleID);
    #endif
    QWidget * parent = NULL;
    const char * name = NULL;
    
    inetdWin = new mod_inetdwin(moduleID, host, parent, name);
    inetdWin->show();
}

void mod_inetd::getFocus()
{
    #ifdef DEBUG_INETD
        debug("\tMod_inetd >>   setting focus");
    #endif
    inetdWin->show();
    inetdWin->setActiveWindow();
    inetdWin->raise();
}
                                        
mod_inetd::~mod_inetd() 
{
    if (inetdWin != NULL) { delete inetdWin; } 
    if (host != NULL) { host->network->cancelRequests(moduleID); }
}
