/*
 * mod_inetd.h:
 *
 * Copyright (c) 1999-2000 Mount Linux Inc.
 * Licensed under the terms of the GPLv2
*/ 

#ifndef __mod_inetdwin_h
#define __mod_inetdwin_h


#include "olympus.h"

#include <unistd.h>

#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qheader.h>
#include <qmenubar.h>
#include <qlistview.h>
#include <qframe.h>
#include <qmessagebox.h>
#include <qtextstream.h>

class service;
class groups;
class inetdlist;

class mod_inetdwin: public QDialog
{
    Q_OBJECT
        
    public:
    
        mod_inetdwin(unsigned int newMID, hostObj * thisHost, QWidget *parent = NULL, const char * name = NULL);
        ~mod_inetdwin();
    
        void closeEvent( QCloseEvent * e);
        void parser();
        service * serviceItem;
        groups * groupsItem;
        int getIndex(QString text, QComboBox* box);
        void prepForEdit();
        void denyEdit();
       
        bool fetching;
        bool saveThis;
        QDialog * fileFetchWindow;
        QString tempGetFile;
        QString tempSendFile;
        QTimer * timer;
                
    public slots:
    
        void notimplemented();        
        void about();
        void aboutQt();
        void helpwindow();
        void close();
        void configureModule();
        void getConfig();
        void connectionKilled();
        void newGroup();
        void newService();
        void saveConfig();
        void editService(QListViewItem*);
        void enableSettingsMenus(bool);
        void configUpdated(unsigned long);
        void updateService(int);
        void updateWait(int, service*);
        void renameItem();
            
    private:
    
        int menuItemNewGroup;
        int menuItemNewService;
        int menuItemRename;
    
        unsigned int moduleID;
        hostObj * host;
        
        inetdlist *ListView; 
        
        service* serviceEditing;
        
        QMenuBar  * menuBar;
        QPopupMenu* fileMenu;
        QPopupMenu* helpMenu;
        
        QPushButton *configurePushButton;
        
        QCloseEvent * event;

        QComboBox *statusComboBox;
        QComboBox *socketComboBox;
        QComboBox *protocolComboBox;
        QComboBox *waitComboBox;
        QComboBox *userComboBox;
        QLineEdit *serverEdit;
        QLineEdit *flagsEdit;
    
        QLabel *mod_name;
        QLabel *mod_group;
        QLabel *mod_desc;
        QLabel *statusField;
        QLabel *socketField;
        QLabel *protocolField;
        QLabel *waitField;
        QLabel *userField;
        QLabel *serverField;
        QLabel *flagsField;
        
        QListViewItem * lastItemAdded;
        groups * lastGroupAdded;
};              

#endif
