/*
 * mod_inetd.h:
 *
 * Copyright (c) 1999-2000 Mount Linux Inc.
 * Licensed under the terms of the GPLv2
*/   
#ifndef __MOD_INETDLIST_H_
#define __MOD_INETDLIST_H_

#include <qlistview.h>
#include <qtimer.h>

#include "forwardRefs.h"
#include "icons.h"

class groups : public QListViewItem
{
    public:
        groups(QListView * newListView);
        groups(QListView * newListView, QListViewItem * myItem);
        ~groups() { delete comments; }
        void setComment(const char * Comment);
        QString* getComment() { return comments; }
        void rename(QString name);
    
    private:
        QString * comments;
};
                                        
class service : public QListViewItem
{
    public:
        service(groups * newGroup);
        service(groups * newGroup, QListViewItem * myItem);
        bool getStatus() { return status; }
        bool getWait() { return wait; }
        QString getName() { return name; }
        QString getSocket() { return inetsocket; }
        QString getProtocol() { return protocol; }
        QString getUser() { return user; }
        QString getProgram() { return program; }
        QString getArgs() { return args; }
        
        bool getorigStatus() { return origstatus; }
        bool getorigWait() { return origwait; }
        QString getorigName() { return origname; }
        QString getorigSocket() { return originetsocket; }
        QString getorigProtocol() { return origprotocol; }
        QString getorigUser() { return origuser; }
        QString getorigProgram() { return origprogram; }
        QString getorigArgs() { return origargs; }
        const char * getLine();
       
        void setStatus(bool Status);
        void setName(QString Name);
        void setSocket(QString Inetsocket);
        void setProtocol(QString Protocol);
        void setWait(bool Wait);
        void setUser(QString User);
        void setProgram(QString Program);
        void setArgs(QString Args);
        
        void setOrigStatus(bool Status);
        void setOrigName(QString Name);
        void setOrigSocket(QString Inetsocket);
        void setOrigProtocol(QString Protocol);
        void setOrigWait(bool Wait);
        void setOrigUser(QString User);
        void setOrigProgram(QString Program);
        void setOrigArgs(QString Args);
        
        void flipState();
        
    private:
        bool status;
        bool wait;
        QString name;
        QString inetsocket;
        QString protocol;
        QString user;
        QString program;
        QString args;
        
        bool origstatus;
        bool origwait;
        QString origname;
        QString originetsocket;
        QString origprotocol;
        QString origuser;
        QString origprogram;
        QString origargs;
};


class inetdlist: public QListView
{
    Q_OBJECT
    
    public:
        inetdlist(QWidget* parent, char* name);
        bool isDragging() { return dragging; }
    private:

        void contentsMouseMoveEvent(QMouseEvent * mouseEvent);
        void contentsMouseReleaseEvent(QMouseEvent *mouseEvent);
        void wheelEvent(QWheelEvent * mouseEvent);
        
        QListViewItem* moveItemTo(QListViewItem*);

        bool dragging;
        bool openAll;
        QListViewItem* draggingItem;
        QTimer* scrollTimer;

    private slots:
        void scrollUp()   { scrollBy(0,-10); } 
        void scrollDown() { scrollBy(0,10); } 
        void onDoubleClick(QListViewItem *);
};

#endif
