/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	mod_admin.h 
*	
*	A module that gets connected to each and every host item to admin the 
*	configuration server
*
*****************************************************************************/

#ifndef __mod_admin_h 
#define __mod_admin_h

#include "plugin.h"

#include <qtabdialog.h>

class mod_adminwin : public QTabDialog {
	Q_OBJECT
	
	public:
		
		mod_adminwin(unsigned int newMID, hostObj * thisHost, char * name);
		void closeEvent( QCloseEvent * e);
		bool changingPassword;
		bool gettingUserList;
        QLineEdit* myPassword;
		QListView* users;
		int stringSequence;
		
	public slots:
		void connect();
		void updateAccount();
		void connectionClosed();	
		void connectionOpenned();
		void requestUserList();
		void addUser();
		void sendAddUser(QString* name, QString* password);
		void editUser();
		void deleteUser();
		
	private:
		unsigned int moduleID;
		hostObj * host;
        QLineEdit * myPassword2;
        netmessage* message;
};


class mod_admin : public plugin
{
	public:
		mod_admin();
		virtual ~mod_admin();
		
		// these return info on the plugin in question
		virtual char * name() { return "Olympus Admin"; }
		virtual char * group() { return "Olympus"; }
		virtual char * desc() { return "Olympus administration."; }
    	virtual char * credits() { return "Aaron J. Seigo <> Mount Linux Inc."; }
		virtual char * version() { return "0.1"; }
		
		// for receiving netmessage objects
		virtual void recv(netmessage *, int);
		
	    // to get focus
        virtual void getFocus();
 
		// the "main" function for the plugin
		virtual void exec(hostObj * thisHost, unsigned int MID, moduleList * thisModL);
	
	private:
		mod_adminwin * adminWin;
};

DLC_Register(mod_admin); 


#endif // __mod_admin_h
