/*****************************************************************************
*
*   Copyright (c) 2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mod_admin.cc
*
*   The basic admin module for controlling the olympus daemon
*   To compile, consult the compile commands at the end of this file.   
*
*****************************************************************************/

#include "mod_admin.h"
#include "editBoxes.h"
#include "ping.h"
#include "nmStrStream.h"
#include "nmUsers.h"

#include <qmainwindow.h>
#include <qdialog.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

#define DEBUG_MODADMIN

mod_admin::mod_admin()
{
    #ifdef DEBUG_MODADMIN
        debug("\tMod_admin >>  opening");
    #endif
    adminWin = NULL;
}

mod_admin::~mod_admin()
{
    if (adminWin != NULL) { delete adminWin; }
    #ifdef DEBUG_MODADMIN
        debug("\tMod_admin >>  closing with MID %i", moduleID);
    #endif
}
 
void mod_admin::exec(hostObj * thisHost, unsigned int MID, moduleList * thisModL)
{
    init(thisHost,MID,thisModL);
    #ifdef DEBUG_MODADMIN
        debug("\tMod_admin >>   my MID is %i", moduleID);
    #endif
    adminWin = new mod_adminwin(moduleID,host,"Admin Module");
    adminWin->setOkButton(NULL);    
    adminWin->show();
}

void mod_admin::recv(netmessage * message, int objectID) 
{ 
    if (adminWin->changingPassword == true)
    {
        if (objectID == COMMAND_SUCCESS)
        {
            QString passwd(adminWin->myPassword->text());
            host->setPassword(&passwd);
            QMessageBox::information(0,"Password change successful", "You password has been changed!");
        }
        else
        {
            QMessageBox::critical(0,"Password change unsuccessful", "There was a problem at the server and your password could not be changed!");
        }
        
        adminWin->changingPassword = false;
    }
    
    if (adminWin->gettingUserList == true)
    {
        cout << "and its because we're getting the user list" << endl;
        if (objectID == COMMAND_STRSTREAM)
        {
            /* we are getting a bunch of strings            
               right now this can only mean users, eventually we'll need to
               discriminate between a user list and a database list */
            nmStrStream* userList = (nmStrStream*) message; 
            int number = userList->amtStrs();
            
            if (adminWin->stringSequence != userList->getSequence()) 
            {        
                adminWin->stringSequence = userList->getSequence();
            }
            
            if (userList->lastPacket() == true) 
            { 
                adminWin->gettingUserList = false; 
                adminWin->stringSequence = 0;
            }
            
            for (int i = 0; i < number; i++)
            {
                new QListViewItem(adminWin->users, userList->getStr(i));
            }
        }
    }
    
    if (objectID == COMMAND_USERS)
    {
        nmUsers* thisUserMessage = (nmUsers*) message;
        debug("mod_admin::recv() >>  action is %i", thisUserMessage->netAction);
        if (thisUserMessage->netAction == NMUSERS_USER_ADDED)
        {
            /*QString message("A new user account ");
            message.append(thisUserMessage->netUser).append(" was added to ").append(*host->getCommonName());
            QMessageBox::information(0,"User Added: " + *host->getCommonName(), message);*/
            adminWin->requestUserList();
        }
        else if (thisUserMessage->netAction == NMUSERS_USER_REMOVED)
        {
            /*QString message("User account ");
            message.append(thisUserMessage->netUser).append(" was removed from ").append(*host->getCommonName());
            QMessageBox::information(0,"User Removed: " + *host->getCommonName(), message);*/
            adminWin->requestUserList();
        }
        else if (thisUserMessage->netAction == NMUSERS_USER_EXISTS) 
        {
            QString message("The ");
            message.append(thisUserMessage->netUser).append(" user account already exists on ");
            message.append(*host->getCommonName()).append(". A new account was not created.");
            QMessageBox::warning(0,"User Add Failed: " + *host->getCommonName(), message);
        }
    }
    
    delete message;
}

void mod_admin::getFocus()
{
    #ifdef DEBUG_MODADMIN
        debug("\tMod_admin >>   setting focus");
    #endif
    adminWin->show();
    adminWin->setActiveWindow();
    adminWin->raise();
}

/*****************************************************************************
*
*   mod_adminwin.cc
*
*   A window class for mod_admin
*
*****************************************************************************/

mod_adminwin::mod_adminwin(unsigned int newMID, hostObj * thisHost, char * name) 
    : QTabDialog(0,name)
{
    moduleID = newMID;
    host = thisHost;
    changingPassword = gettingUserList = false;
    stringSequence = 0;
    
    QObject::connect(host, SIGNAL(connectionOpenned()),
                     this, SLOT(connectionOpenned()));
    QObject::connect(host, SIGNAL(connectionClosed()),
                     this, SLOT(connectionClosed()));

    setCaption(*host->getCommonName() + ":  Olympus Admin");
    
    // the "My Account" tab
    QWidget * myInfoPage = new QWidget(0,"property page");
    
    QLabel * infoPageInfo = new QLabel(myInfoPage,"infoPageInfo");
    infoPageInfo->setText("To change your password, enter a new password and confirm it in the spaces below and click Update Password.");
    infoPageInfo->setAlignment(QLabel::WordBreak);
    infoPageInfo->setAutoResize(true);
    
    QLabel * labelPassword = new QLabel(myInfoPage,"labelPassword");
    labelPassword->setText("New Password: ");
    myPassword = new QLineEdit(myInfoPage,"myPassword");
    myPassword->setEchoMode(QLineEdit::Password);
    
    QLabel * labelPassword2 = new QLabel(myInfoPage,"labelPassword");
    labelPassword2->setText("Confirm: ");
    myPassword2 = new QLineEdit(myInfoPage,"myPassword");
    myPassword2->setEchoMode(QLineEdit::Password);
    
    QPushButton * changeButton = new QPushButton(myInfoPage,"changeButton");
    changeButton->setText("Update Password");
    
    QObject::connect(changeButton, SIGNAL(clicked()),
                    this, SLOT(updateAccount()));
    
    QGridLayout * myInfoTab = new QGridLayout(myInfoPage,0,0);
    myInfoTab->addColSpacing(0,10);
    myInfoTab->addColSpacing(1,175);
    myInfoTab->addColSpacing(2,10);
    myInfoTab->addColSpacing(3,myPassword->size().width());
    myInfoTab->addColSpacing(4,100);
    myInfoTab->addColSpacing(5,10);
    
    myInfoTab->addRowSpacing(0,10);
    myInfoTab->addMultiCellWidget(infoPageInfo,1,5,1,1);
    myInfoTab->addWidget(labelPassword,1,3);
    myInfoTab->addWidget(myPassword,1,4);
    myInfoTab->addRowSpacing(2,5);
    myInfoTab->addWidget(labelPassword2,3,3);
    myInfoTab->addWidget(myPassword2,3,4);
    myInfoTab->addRowSpacing(4,5);
    myInfoTab->addMultiCellWidget(changeButton,5,5,3,4);
    myInfoTab->addRowSpacing(6,10);
    
    this->addTab(myInfoPage, "My Password");
    
    
    // the "All Accounts" tab
    QWidget* usersPage = new QWidget(0,"property page");
    QGridLayout* usersTab = new QGridLayout(usersPage,0,0);
    
    QPushButton* addButton = new QPushButton(usersPage);
    addButton->setText("Add New...");
    QObject::connect(addButton, SIGNAL(clicked()),   
                     this, SLOT(addUser()));
    
    QPushButton* editButton = new QPushButton(usersPage);
    editButton->setText("Edit...");
    QObject::connect(editButton, SIGNAL(clicked()),   
                     this, SLOT(editUser()));
    editButton->setEnabled(false);
    
    QPushButton* deleteButton = new QPushButton(usersPage);
    deleteButton->setText("Delete...");
    QObject::connect(deleteButton, SIGNAL(clicked()),   
                     this, SLOT(deleteUser()));
    
    QPushButton* refreshButton = new QPushButton(usersPage);
    refreshButton->setText("Fetch List");
    QObject::connect(refreshButton, SIGNAL(clicked()),   
                     this, SLOT(requestUserList()));
    
    int buttonSize = addButton->sizeHint().width();
    int columnWidth = ((buttonSize * 4)) / 3;
    
    users = new QListView(usersPage,"usersList");
    users->setPalette(*client->listPalette);
    users->setRootIsDecorated(false);
    users->setItemMargin(2);
    users->setSorting(0, true);
    users->setMultiSelection(false);
    users->setAllColumnsShowFocus(true);
    users->addColumn("Username", columnWidth);
    users->addColumn("Privileges", columnWidth);
    users->addColumn("Last Login", columnWidth);

    usersTab->addColSpacing(0, buttonSize);
    usersTab->addColSpacing(1, buttonSize);
    usersTab->addColSpacing(2, buttonSize);
    usersTab->addColSpacing(3, buttonSize);
    
    usersTab->addMultiCellWidget(users,0,0,0,3);
    usersTab->addRowSpacing(1,5);
    usersTab->addWidget(addButton, 2, 0);
    usersTab->addWidget(editButton, 2, 1);
    usersTab->addWidget(deleteButton, 2, 2);
    usersTab->addWidget(refreshButton, 2, 3);
    
    this->addTab(usersPage, "All Users");
    
    setFixedSize(250,200);
}

void mod_adminwin::connect() 
{
    if (host->isConnected())
    {
        #ifdef DEBUG_MODADMIN
            debug("disconnecting <<thunk>>");
        #endif
        host->disconnect();
    }
    else
    {
        #ifdef DEBUG_MODADMIN
            debug("connecting <<bring bring>>");
        #endif
        host->connect();
    }
}

void mod_adminwin::connectionOpenned()
{
    #ifdef DEBUG_MODADMIN
        debug("connection openned");
    #endif
}

void mod_adminwin::connectionClosed()
{
    #ifdef DEBUG_MODADMIN
        debug("connection closed");
    #endif
    changingPassword = false;
    gettingUserList = false;
}

void mod_adminwin::updateAccount() 
{
    #ifdef DEBUG_MODADMIN
        debug("mod_admin::updateAccount >>  updating account");
    #endif
    
    if (myPassword->text() == myPassword2->text())
    {
        #ifdef DEBUG_MODADMIN
            debug("mod_admin::updateAccount >>  passwords match, prepping netmessage");
        #endif
        message = new nmUsers((char*) host->getUsername()->data(),
                              (char*) myPassword->text().data(),
                               NMUSERS_CHANGE_PASSWORD,
                               host->getRawSocket(),
                               moduleID,
                               COMMAND_USERS);
        changingPassword = true;
        
        #ifdef DEBUG_MODADMIN
            debug("mod_admin::updateAccount >>  queuing netmessage");
        #endif
        host->network->queueMessage(message);
    }
    else
    {
        QMessageBox::critical(0,"Password Change Error", "The new password and the confirmation password do not match.\nPlease try again");
    }
    
    #ifdef DEBUG_MODADMIN
        debug("mod_admin::updateAccount >>  finished prepping to change password.");
    #endif
}

void mod_adminwin::requestUserList()
{
    #ifdef DEBUG_MODADMIN
        debug("mod_admin::requestUserList >>  requestUserList");
    #endif
    
    users->clear();
    stringSequence = 0;
    gettingUserList = true;
    nmUsers* message = new nmUsers("get",
                               "now",
                               NMUSERS_LIST_ALL,
                               host->getRawSocket(),
                               moduleID,
                               COMMAND_USERS);
    
    host->network->queueMessage(message);
    
    #ifdef DEBUG_MODADMIN
        debug("mod_admin::requestUserList >>  finished requestUserList.");
    #endif
}

void mod_adminwin::addUser()
{
    mod_admin_adduser* addUserWin = new mod_admin_adduser(host->getCommonName());
    QObject::connect(addUserWin, SIGNAL(addThisUser(QString*, QString*)),
                     this, SLOT(sendAddUser(QString*, QString*)));
    addUserWin->show();
}

void mod_adminwin::sendAddUser(QString* name, QString* password)
{
    nmUsers* newUserMessage = new nmUsers((char*) name->data(), (char*) password->data(), NMUSERS_ADD_USER, 
                                          host->getRawSocket(), moduleID, COMMAND_USERS);
    
    host->network->queueMessage(newUserMessage);
}

void mod_adminwin::editUser()
{
    cout << "lazy bastard didn't give me no real purpose in life!" << endl;
}

void mod_adminwin::deleteUser()
{
    QListViewItem* selectedUser;
    
    if ((selectedUser = users->selectedItem()) == NULL) { return; }
    
    /*	    confirmDeleteBox->setButtonText( 1, "Yes");
    	confirmDeleteBox->setButtonText( 2, "No");
	*/    
    
    if (! QMessageBox::critical(0, "Olympus: Confirm Delete", "Delete Olympus user account " + selectedUser->text(0) + "?", "Yes", "No")) 
    {
        nmUsers* newUserMessage = new nmUsers((char*) selectedUser->text(0).data(), "a", NMUSERS_REMOVE_USER, 
                                          host->getRawSocket(), moduleID, COMMAND_USERS);
    
        host->network->queueMessage(newUserMessage);    
    }
}

void mod_adminwin::closeEvent( QCloseEvent * closeEvent)
{
    closeEvent->accept();
    client->deleteModule(moduleID);
}
