/*****************************************************************************
*
*   Copyright (c) 2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   editBoxes.h
*
*   Classes for the edit boxes used in mod_admin 
*
*****************************************************************************/

#include "editBoxes.h"
#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

mod_admin_adduser::mod_admin_adduser(QString* hostname)
    : QDialog(0, "addUserWindow", false)
{
    hostName.append(*hostname);
    setCaption("Add User To " + hostName);
    
    QLabel *newLabel = new QLabel("<b>Add new user</b>", this, "newLabel");
    newLabel->setAlignment(QLabel::AlignCenter | QLabel::ExpandTabs);
    newLabel->setTextFormat(QLabel::RichText);
    newLabel->setAutoResize(true);

    QLabel *explainLabel = new QLabel("<font size=3>Enter a username and password, then press the \"Add\" button.</font>", this, "explainLabel");
    explainLabel->setAlignment(QLabel::AlignLeft | QLabel::AlignTop | QLabel::ExpandTabs | QLabel::WordBreak);
    explainLabel->setAutoResize(true);
    explainLabel->setFrameStyle(QFrame::Box | QFrame::Sunken);

    QFrame *hbar = new QFrame(this,"hbar");
    hbar->setFrameStyle(QFrame::HLine | QFrame::Sunken);

    QLabel *newUsernameLabel = new QLabel(this,"newUsernameLabel");
    newUsernameLabel->setText("Username:");
    newUsername = new QLineEdit(this,"username");
    
    QLabel *newPasswordLabel = new QLabel(this,"newPasswordLabel");
    newPasswordLabel->setText("Password:");
    newPassword = new QLineEdit(this,"password");
    newPassword->setEchoMode(QLineEdit::Password);
    newPasswordLabel->setFixedSize(newPasswordLabel->sizeHint());

    QLabel *newPasswordLabel2 = new QLabel(this,"newPasswordLabel");
    newPasswordLabel2->setText("Confirm:");
    newPassword2 = new QLineEdit(this,"password2");
    newPassword2->setEchoMode(QLineEdit::Password);
    newPasswordLabel2->setFixedSize(newPasswordLabel->sizeHint());

    QPushButton *newButton = new QPushButton(this,"newButton");
    newButton->setText("Add User");
    
    QPushButton *exitButton = new QPushButton(this,"exitButton");
    exitButton->setText("Cancel");
    
    QGridLayout* addUserWidgets = new QGridLayout(this,0,0,0,0,"addUserWidgets");
    addUserWidgets->addColSpacing(0,10);
    addUserWidgets->addColSpacing(2,8);
    addUserWidgets->addColSpacing(4,8);
    addUserWidgets->addColSpacing(6,10);
    addUserWidgets->addRowSpacing(1,10);
    addUserWidgets->addMultiCellWidget(newLabel, 1, 1, 1, 6, 0);
    addUserWidgets->addRowSpacing(2,10);
    addUserWidgets->addWidget(newUsernameLabel,3,1);
    addUserWidgets->addWidget(newUsername,3,3);
    addUserWidgets->addRowSpacing(4,5);
    addUserWidgets->addWidget(newPasswordLabel,5,1);
    addUserWidgets->addWidget(newPassword,5,3);
    addUserWidgets->addWidget(exitButton,5,5);
    addUserWidgets->addWidget(newPasswordLabel2,6,1);
    addUserWidgets->addWidget(newPassword2,6,3);
    addUserWidgets->addWidget(newButton,6,5);
    addUserWidgets->addRowSpacing(7,20);
    addUserWidgets->addMultiCellWidget(hbar, 7, 7, 1, 5, 0);
    addUserWidgets->addRowSpacing(8,explainLabel->minimumSizeHint().height());
    addUserWidgets->addMultiCellWidget(explainLabel, 8, 8, 1, 5, 0);
    addUserWidgets->addRowSpacing(9,5);

    /*  set the size of the window... 
        too bad setFixedSize doesn't work as advertised */
    this->setFixedSize(addUserWidgets->sizeHint());
 
    // connect the lineEdit newPassword and the pushButton newButton
    // to the accept() of the dialog and the mainWindow slot that stores the
    // password value entered
    QObject::connect(newPassword2, SIGNAL(returnPressed()), this, SLOT(submitUser()));
    QObject::connect(newButton, SIGNAL(clicked()), this, SLOT(submitUser()));
    QObject::connect(exitButton, SIGNAL(clicked()), this, SLOT(closeIt()));

    newUsername->setFocus();
}

void mod_admin_adduser::submitUser()
{
    if (newPassword->text() != newPassword2->text())
    {
        QString message("Attempting to add user to "); 
        message.append(hostName).append(":<BR> The passwords supplied did not match each other.\nPlease try again.");
        QMessageBox::information(0,"Add New User Error", message);
        return;
    }
    
    QString username(newUsername->text());
    QString password(newPassword->text());
    
    emit addThisUser(&username, &password);
    
    closeIt();
}

void mod_admin_adduser::closeIt() { delete this; }