/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   ping.cc 
*
*   This pings the olympus server, for lag time and the such
*
*****************************************************************************/

#include "olympus.h"
#include "ping.h"
#include "guisocket.h"
#include "hostObj.h"
#include "netmessage.h"
#include "nmPing.h"

//#define DEBUG_PING

#include <qdialog.h>
#include <qlayout.h>
#include <qtextview.h>
#include <qtimer.h>
#include <qpushbutton.h>

ping::ping(hostObj * hostToPing) 
{
    host = hostToPing; 
    moduleID = ++client->midCounter;
    moduleIDStr.setNum(moduleID,10);
    timer = NULL;
    sent = 0;
    recvd = 0;
    minTime = 0xffffff;
    maxTime = 0;
    totalTime = 0;
    
    #ifdef DEUBG_PING
        debug("ping::ping() >> ID = %i",moduleID);
    #endif
    
    pingWindow = new QDialog(0, "pinger", false);
    pingWindow->setCaption(*host->getCommonName() + ":  Pinging");   
    
    pingResults = new QTextView(pingWindow, "pingResults");
    pingResults->resizeContents(300,150);
    pingResults->setText("Starting Ping...");
    
    QPushButton * closeButton = new QPushButton(pingWindow);
    closeButton->setText("Close");
    
    QObject::connect(closeButton, SIGNAL(clicked()),
                     this, SLOT(close()));
    
    QGridLayout * pingLayout = new QGridLayout(pingWindow,5,3,0,0);
    pingLayout->addColSpacing(0,10);
    pingLayout->addColSpacing(3,10);
    pingLayout->addRowSpacing(0,10);
    pingLayout->addWidget(pingResults,1,1);
    pingLayout->addRowSpacing(2,10);
    pingLayout->addWidget(closeButton,3,1);
    pingLayout->addRowSpacing(4,10);
    
    pingWindow->resize(pingLayout->sizeHint().width() + 100, pingLayout->sizeHint().height() + 100);
    
    pingWindow->show();
    client->openModules->insert(moduleIDStr,(plugin *)this);
    
    if (! host->isConnected()) 
    { 
        host->connect(); 
        QObject::connect(host, SIGNAL(connectionOpenned()),
                         this,   SLOT(commence()));
    }
    else
    {
        commence();
    }
    QObject::connect(host, SIGNAL(connectionClosed()),
                     this,   SLOT(cease()));
    
}

ping::~ping() 
{ 
    if (timer != NULL) { delete timer; }
    client->openModules->remove(moduleIDStr);
    delete pingWindow; 
}
 
void ping::commence()
{
    QObject::disconnect(host, SIGNAL(connectionOpenned()),
                         this,   SLOT(commence()));
    timer = new QTimer(0, "ping timer");
    QObject::connect(timer, SIGNAL(timeout()),
                     this,    SLOT(pingSend()));
    timer->start(1000);
}

void ping::cease() 
{
    if (timer == NULL) { return; }
    else
    {
        delete timer;
        timer = NULL;
    }
    
    QString numString;
    QString newline;
    int average = 0;
    
    if (recvd > 0) { average = totalTime / recvd; }
    if (minTime == 0xffffff) { minTime = 0; }
    
    // QT2.1
//    pingResults->append("\n");
    newline.append("\n");
    newline.append(tr("Stopped.  Sent: "));
    newline.append(numString.setNum(sent,10));
    newline.append(tr("  Received: "));
    newline.append(numString.setNum(recvd,10));
    // QT2.1
//    pingResults->append(newline);
    
    // QT2.1
//    newline.truncate(0);
    newline.append("\n");
    newline.append(tr("Round trip min/avg/max = "));
    newline.append(numString.setNum(minTime,10));
    newline.append("/");
    newline.append(numString.setNum(average,10));
    newline.append("/");
    newline.append(numString.setNum(maxTime,10));
    pingResults->setText(pingResults->text() + newline);
}

void ping::close()
{
    delete this;
}

void ping::pingSend() 
{
    #ifdef DEBUG_PING
        debug("\nping::pingSend() >>  queueing a ping packet");
    #endif
    if (sent < 10 && sent++ < 1000)
    {   
        nmPing * pingPacket = new nmPing(host->getRawSocket(), moduleID, COMMAND_PING);
        host->network->queueMessage(pingPacket);
    }
    else
    {
        cease();
    }
    #ifdef DEBUG_PING
        debug("ping::pingSend() >>  queued\n");
    #endif
}

void ping::recv(netmessage * message, int messageID) 
{
    #ifdef DEBUG_PING
        debug("\nping::recv() >>  got a message of type %i\n", messageID);
    #endif
    
    if (messageID == COMMAND_PING)
    {
        nmPing *pingReturn = (nmPing *)message;
        pingReturn->activate();
        
        // do the tallies for the final report
        recvd++;
                
        totalTime += pingReturn->elapsedTime;
        
        if (minTime > pingReturn->elapsedTime) { minTime = pingReturn->elapsedTime; }
        if (maxTime < pingReturn->elapsedTime) { maxTime = pingReturn->elapsedTime; }
        
        QString numeric;
        QString newline;
        
        if (recvd < 10) { newline.append("\n "); }
        else { newline.append("\n "); }
        newline.append(numeric.setNum(recvd));
        newline.append(tr("> Response from "));
        newline.append(*host->getCommonName());
        newline.append(tr(" received. Round trip took "));
        newline.append(numeric.setNum(pingReturn->elapsedTime,10));
        newline.append(tr(" ms."));
    // QT2.1
//        pingResults->append(newline);
        pingResults->setText(pingResults->text() + newline);
    }
    
    delete message;
}
