/*********************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nm_users.cc
 *
 * this class implements the virtual methods out of the netmessage
 * class.  this class serializes the request to set the pasword on the
 * server host.
 *********************************************************************/

#include "nmUsers.h"

// the constructor simply assigns the references to the class variables

nmUsers::nmUsers(char* user, char* passwd , int action , transport * connection, unsigned long sessionID , unsigned long commandID)
    :netmessage(connection,sessionID,commandID)
{
    if (user == NULL)
    {
        netUser = new char[1];
        netUser[0] = '\0';
	}
	else
	{
        netUser = new char[strlen(user) + 1];
        strncpy(netUser,user,strlen(user) + 1);	
	}
    
    if (passwd == NULL)
    {
        netPasswd = new char[1];
        netPasswd[0] = '\0';
	}
	else
	{
        netPasswd = new char[strlen(passwd) + 1];
        strncpy(netPasswd,passwd,strlen(passwd) + 1);
    }
    
	netAction = action;
  
    members->add(&netUser, nmMemberList::charstarType, 0);
    members->add(&netPasswd, nmMemberList::charstarType, 0);
    members->add(&netAction, nmMemberList::intType, 0);
}

int  nmUsers::activate()
{
    return 1;
}

void nmUsers::prepareToSend()
{
    nmMemberList * currMember;

    currMember = members->nextMember;
    currMember->length = strlen(netUser);

    currMember = currMember->nextMember;
    currMember->length = strlen(netPasswd);

    currMember = currMember->nextMember;
    currMember->length = SIZEOF_INT;
}

// release all the resources that the instance of the class uses.
nmUsers::~nmUsers()
{
    delete netUser;
    delete netPasswd;
}
