/*
 * nmUserAuth.cc: a netmessage for user authentication
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "nmUserAuth.h"

nmUserAuth::nmUserAuth(QString * user, 
                       QString * pass, 
                       transport * connection, 
                       unsigned long sessionID, 
                       unsigned long commandID)
  : netmessage(connection, sessionID,commandID)
{
    username = new char[user->length() + 1];
    strncpy(username,user->data(),user->length()+1);
    
    password = new char[pass->length() + 1];
    strncpy(password,pass->data(),pass->length()+1);
    
    members->add(&username, nmMemberList::charstarType, strlen(username));
    members->add(&password, nmMemberList::charstarType, strlen(password));
}

nmUserAuth::~nmUserAuth(void)
{
    delete username;
    delete password;
}

int nmUserAuth::activate(void)
{
    return 1;
}

void nmUserAuth::prepareToSend()
{
    nmMemberList * currMember;
    
    currMember = members->nextMember;
    currMember->length = strlen(username);
    
    currMember = currMember->nextMember;
    currMember->length = strlen(password);
}
