/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmStrStream.cc
 *
 * Enables sending of long sequences of char* type strings to a client
 *********************************************************************/

#include "nmStrStream.h"

nmStrStream::nmStrStream(transport * connection, 
                    unsigned long sessionID, 
                    unsigned long commandID)
    : netmessage(connection, sessionID, commandID)
{
    sequence = 0;
    filled = 0;
    strings[0] = NULL;
    strings[1] = NULL;
    strings[2] = NULL;
    strings[3] = NULL;
    strings[4] = NULL;
    strings[5] = NULL;
    strings[6] = NULL;
    strings[7] = NULL;
    strings[8] = NULL;
    strings[9] = NULL;
    
    members->add(&sequence, nmMemberList::intType, SIZEOF_INT);
    members->add(&filled, nmMemberList::intType, SIZEOF_INT);    
    
    members->add(&strings[0], nmMemberList::charstarType, 0);
    members->add(&strings[1], nmMemberList::charstarType, 0);
    members->add(&strings[2], nmMemberList::charstarType, 0);
    members->add(&strings[3], nmMemberList::charstarType, 0);
    members->add(&strings[4], nmMemberList::charstarType, 0);
    members->add(&strings[5], nmMemberList::charstarType, 0);
    members->add(&strings[6], nmMemberList::charstarType, 0);
    members->add(&strings[7], nmMemberList::charstarType, 0);
    members->add(&strings[8], nmMemberList::charstarType, 0);
    members->add(&strings[9], nmMemberList::charstarType, 0);
}

nmStrStream::~nmStrStream() 
{
    for (int i = 0; i < StrStreamCapacity; i++) { if (strings[i] != NULL) { delete strings[i]; } }
}

int nmStrStream::activate()
{
     return 1;
}

void nmStrStream::prepareToSend()
{
    if (members->nextMember != NULL) { delete members->nextMember; }
    
    members->add(&sequence, nmMemberList::intType, SIZEOF_INT);
    members->add(&filled, nmMemberList::intType, SIZEOF_INT);    
    
    members->add(&strings[0], nmMemberList::charstarType, strlen(strings[0]));
    members->add(&strings[1], nmMemberList::charstarType, strlen(strings[1]));
    members->add(&strings[2], nmMemberList::charstarType, strlen(strings[2]));
    members->add(&strings[3], nmMemberList::charstarType, strlen(strings[3]));
    members->add(&strings[4], nmMemberList::charstarType, strlen(strings[4]));
    members->add(&strings[5], nmMemberList::charstarType, strlen(strings[5]));
    members->add(&strings[6], nmMemberList::charstarType, strlen(strings[6]));
    members->add(&strings[7], nmMemberList::charstarType, strlen(strings[7]));
    members->add(&strings[8], nmMemberList::charstarType, strlen(strings[8]));
    members->add(&strings[9], nmMemberList::charstarType, strlen(strings[9]));
}

bool nmStrStream::lastPacket()
{ 
    if (filled == StrStreamCapacity) { return false; }
    else { return true; }
}

char* nmStrStream::getStr(int index)
{
    if (index > StrStreamCapacity) { return NULL; }
    return strings[index];
}
