/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmSourceExpand.cc
 *
 * Transmit a tarball from a client to the server and get status
 * on when it reaches the server.
 *****************************************************************/

#include "nmSourceExpand.h"

#define DEBUG_NMSOURCEEXPAND

// constructor takes as arguments:
// Socket class - open socket in this class
// sessionID    - what client does this belong to.
// _filePath    - absolute path to the tarball to install

nmSourceExpand::nmSourceExpand(const char* _filePath,
                               const char* _tarname,
                               transport *connection,
                               unsigned long sessionID,
                               unsigned long commandID) :
    netmessage(connection, sessionID, commandID)
{
    char* tmpPtr;
    int tmp;

#if defined(DEBUG_NMSOURCEEXPAND)    
    cout << "file=" << _filePath << ". tarball=" << _tarname << endl;
#endif
    // initialize class variables
    streamFile = 0;

    tmp = strlen(_filePath);
    filePath = new char[tmp + 1];
    strncpy(filePath, _filePath, tmp);
    filePath[tmp] = '\0';
    tmp = strlen(_tarname);
    pkgname = new char[tmp + 1];
    strncpy(pkgname, _tarname, tmp);
    pkgname[tmp] = '\0';

    tmpPtr = strrchr(filePath, '/');
    tmpPtr++;
    filename = new char[strlen(tmpPtr) + 1];
    strncpy(filename, tmpPtr, strlen(tmpPtr));
    filename[strlen(tmpPtr)] = '\0';

#if defined(DEBUG_NMSOURCEEXPAND)
    cerr << "nmSourceExpand::nmSourceExpand: constructor" << endl;
#endif
}

// instantiated by the client on the return trip
nmSourceExpand::nmSourceExpand(transport* connection, unsigned long sessID, unsigned long commID)
    : netmessage(connection, sessID, commID)
{
    members->add(&filename, nmMemberList::charstarType, 0);
    members->add(&pkgname, nmMemberList::charstarType, 0);
    members->add(&processStatus, nmMemberList::intType, 0);
    members->add(&numberOfFiles, nmMemberList::intType, 0);
    members->add(&elapsedsec, nmMemberList::intType, 0);
    members->add(&elapsedusec, nmMemberList::intType, 0);
    members->add(&streamFile, nmMemberList::fileType, 0);
#if defined(DEBUG_NMSOURCEEXPAND)
    cerr << "nmSourceExpand::nmSourceExpand: constructor" << endl;
#endif
}

int nmSourceExpand::activate()
{
    int retc = -1;

    if ((tarballFD = open(streamFile, O_RDONLY)) > 0)
    {
        retc = 1;
    }
#if defined(DEBUG_NMSOURCEEXPAND)
    cerr << "nmSourceExpand::activate: retc=" << retc << endl;
#endif

    return (retc);
}

// set the lengths of the members
void nmSourceExpand::prepareToSend()
{
    struct stat st;
    int fileLength = 0;

    delete members->nextMember;
    members->nextMember = NULL;
    if (tarballFD > 0 && stat(filePath, &st) == 0)
    {
        fileLength = st.st_size;
    }

    // send these
    members->add(&filename, nmMemberList::charstarType, strlen(filename));
    members->add(&pkgname, nmMemberList::charstarType, strlen(pkgname));
    members->add(&filePath, nmMemberList::fileType, fileLength);
}

// return the name of the results file
char* nmSourceExpand::getFileName()
{
    return (streamFile);
}

// return the number of files expanded
int nmSourceExpand::getNumberOfFiles()
{
    return (numberOfFiles);
}

// return the elapsed time
int nmSourceExpand::getElapsedSeconds()
{
    return (elapsedsec);
}

// return the micro seconds
int nmSourceExpand::getElapsedUSeconds()
{
    return (elapsedusec);
}
