/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmSourceConfig.cc
 *
 * Send the request to build the package on the server host.  Of
 * course this requires that the host have the necessary tools
 * (compiler etc) to build the package.
 *****************************************************************/

#include "nmSourceConfig.h"

// constructor
nmSourceConfig::nmSourceConfig(const char* name, transport* connection, unsigned int sessID, unsigned int commID)
    : netmessage(connection, sessID, commID)
{
    int tmp;

    tmp = strlen(name);
    pkgname = new char[tmp + 1];
    strcpy(pkgname, name);
    filename = 0;
    options = 0;
    streamFile = 0;
    processStatus = seconds = useconds = 0;
}

// used on the return trip from the server
nmSourceConfig::nmSourceConfig(transport* connection, unsigned long sessID, unsigned long commID)
    : netmessage(connection, sessID, commID)
{
    delete members->nextMember;
    members->nextMember = NULL;

    members->add(&filename, nmMemberList::charstarType, 0);
    members->add(&pkgname, nmMemberList::charstarType, 0);
    members->add(&processStatus, nmMemberList::intType, 0);
    members->add(&seconds, nmMemberList::intType, 0);
    members->add(&useconds, nmMemberList::intType, 0);
    members->add(&streamFile, nmMemberList::fileType, 0);
#if defined(DEBUG_NMSOURCEEXPAND)
    cerr << "nmSourceExpand::nmSourceExpand: constructor" << endl;
#endif
}

// destructor
nmSourceConfig::~nmSourceConfig()
{
    delete[] filename;
    delete[] options;
    delete[] pkgname;
    delete[] streamFile;
}

int nmSourceConfig::activate()
{
    return 1;
}

// access method for the original tar file name
char* nmSourceConfig::getFileName()
{
    return (filename);
}

// access method for the package name
char* nmSourceConfig::getPkgName()
{
    return (pkgname);
}

// access method for the process status
int nmSourceConfig::getProcessStatus()
{
    return (processStatus);
}

// access method for the elapsed seconds
int nmSourceConfig::getSeconds()
{
    return (seconds);
}

// access method for the elapsed microseconds
int nmSourceConfig::getUSeconds()
{
    return (useconds);
}

// access method for the output from the process
char* nmSourceConfig::getStreamFile()
{
    return (streamFile);
}

// reimplement this method
void nmSourceConfig::prepareToSend()
{
    delete members->nextMember;
    members->nextMember = NULL;

    members->add(&pkgname, nmMemberList::charstarType, strlen(pkgname));
    members->add(&options, nmMemberList::charstarType, strlen(options));
}

// set the options string
void nmSourceConfig::setOptions(const char* _options)
{
    int tmp = strlen(_options);

    options = new char[tmp];
    strncpy(options, _options, tmp);
    options[tmp] = '\0';
}
