/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmSourceBuild.cc
 *
 * Send the request to build the package on the server host.  Of
 * course this requires that the host have the necessary tools
 * (compiler etc) to build the package.
 *****************************************************************/

#include "nmSourceBuild.h"

// constructor
nmSourceBuild::nmSourceBuild(const char* name, transport* socket, unsigned int sessionID, unsigned int commandID)
    : netmessage(socket, sessionID, commandID)
{
    unsigned int tmp;

    // get our own copy of the name
    tmp = strlen(name);
    pkgname = new char[tmp + 1];
    strncpy(pkgname, name, tmp);
    pkgname[tmp] = '\0';

    // initialize values
    streamFile = 0;
    processStatus = 0;
    seconds = 0;
    useconds = 0;

    // members to send
    members->add(&filename, nmMemberList::charstarType, 0);
    members->add(&pkgname, nmMemberList::charstarType, 0);
    members->add(&processStatus, nmMemberList::intType, 0);
    members->add(&seconds, nmMemberList::intType, 0);
    members->add(&useconds, nmMemberList::intType, 0);
    members->add(&streamFile, nmMemberList::fileType, 0);
}

// destructor
nmSourceBuild::~nmSourceBuild()
{
    delete[] pkgname;
    delete[] options;
}

// other methods
int nmSourceBuild::activate()
{
    return 1;
}

// return the file name of the tarball
char* nmSourceBuild::getFileName()
{
    return (filename);
}

// return the name of the package
char* nmSourceBuild::getPkgName()
{
    return (pkgname);
}

// return the name of the output stream file
char* nmSourceBuild::getStreamFile()
{
    return (streamFile);
}

// return the process status
int nmSourceBuild::getProcessStatus()
{
    return (processStatus);
}

// return the seconds of processing time
int nmSourceBuild::getSeconds()
{
    return (seconds);
}

// return the microseconds of processing time as a fraction of a second
int nmSourceBuild::getUSeconds()
{
    return (useconds);
}

// set up the members to send
void nmSourceBuild::prepareToSend()
{
    members->add(&pkgname, nmMemberList::charstarType, strlen(pkgname));
    members->add(&options, nmMemberList::charstarType, strlen(options));
}

// set the options
void nmSourceBuild::setOptions(const char *_options)
{
    options = new char[strlen(_options) + 1];
    strcpy(options, _options);
}
