/*********************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmPing.h
 *
 * used to ping a host's olympus server.
 *********************************************************************/

#include "nmPing.h"

nmPing::nmPing(transport * connection,
               unsigned long sessionID, 
               unsigned long commandID)
    : netmessage(connection,sessionID,commandID)
{
    members->add(&seconds, nmMemberList::longType, SIZEOF_LONG);
    members->add(&usecs, nmMemberList::longType, SIZEOF_LONG);
}


void nmPing::prepareToSend(void)
{
    timeval timecombo;
    gettimeofday(&timecombo,NULL);
    
    seconds = timecombo.tv_sec;
    usecs = timecombo.tv_usec;
}

int nmPing::activate()
{
    timeval timecombo;
    gettimeofday(&timecombo,NULL);
    
    elapsedTime = ((timecombo.tv_sec * 1000) + (timecombo.tv_usec / 1000)) - ((seconds * 1000) + (usecs / 1000));
    
    return 1;
}

nmPing::~nmPing() {}
