/*
 * nmKexReply.cc:
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "config.h"
#include "bn.h"
#include "nmKexReply.h"

nmKexReply::nmKexReply(transport* connection, unsigned long sessionID, unsigned long commandID)
    : netmessage(connection, sessionID, commandID)
{
    f = NULL;
}

nmKexReply::~nmKexReply(void)
{
    if (f != NULL)
    {
        delete f;
    }
}

int nmKexReply::activate(void)
{
    return 1;
}

void nmKexReply::prepareToSend(void)
{
    struct BigNum* pubkey;
    int nbytes_f;

    if ((pubkey = socket->kexPublic()) != NULL)
    {
        nbytes_f = bnBytes(pubkey);
        nbits_f = nbytes_f << 3;

        f = new unsigned char[nbytes_f];
        bnExtractLittleBytes(pubkey, f, 0, nbytes_f);

        members->add(&nbits_f, nmMemberList::intType, SIZEOF_INT);
        members->add(&f, nmMemberList::binaryType, nbytes_f);
    }
}
