/*
 * nmKexInit.cc: get primes for Diffie Hellman key exchange
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */
 
#include "bn.h"
#include "nmKexInit.h"

nmKexInit::nmKexInit(transport* connection, unsigned long sessionID, unsigned long commandID, int n)
    : netmessage(connection, sessionID, commandID)
{
    nbits_p = n;
    p = g = f = NULL;
    members->add(&nbits_p, nmMemberList::intType, SIZEOF_INT);
}

nmKexInit::nmKexInit(transport* connection, unsigned long sessionID, unsigned long commandID)
    : netmessage(connection, sessionID, commandID)
{
    p = g = f = NULL;
    members->add(&nbits_p, nmMemberList::intType, SIZEOF_INT);
    members->add(&p, nmMemberList::binaryType, 0);
    members->add(&nbits_g, nmMemberList::intType, SIZEOF_INT);
    members->add(&g, nmMemberList::binaryType, 0);
    members->add(&nbits_f, nmMemberList::intType, SIZEOF_INT);
    members->add(&f, nmMemberList::binaryType, 0);
}

nmKexInit::~nmKexInit(void)
{
    if (p != NULL)
    {
        delete p;
    }

    if (g != NULL)
    {
        delete g;
    }

    if (f != NULL)
    {
        delete f;
    }
}

int nmKexInit::activate(void)
{
    if (nbits_p <= 1536 && nbits_g <= 16)
    {
        struct BigNum prime, generator, pubkey;

        bnBegin(&prime);
        bnInsertLittleBytes(&prime, p, 0, nbits_p >> 3);

        bnBegin(&generator);
        bnInsertLittleBytes(&generator, g, 0, nbits_g >> 3);

        bnBegin(&pubkey);
        bnInsertLittleBytes(&pubkey, f, 0, nbits_f >> 3);

        socket->kexInit(&prime, &generator);
        socket->kexGenerate(&pubkey);

        return 1;
    }
    return -1;
}

void nmKexInit::prepareToSend(void)
{
}
