/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nm_fetchconfig.cc
 *
 * Provide the "mode" and file and the server will retrieve the
 * configuration and return it in the class member buffer.
 *****************************************************************/

#include "nmFetchConfig.h"
#include <qfile.h>

nmFetchConfig::nmFetchConfig(
    char* _module,
    char* _file,    
    transport *connection,
    unsigned long sessionID,
    unsigned long commandID
)
    : netmessage(connection,sessionID,commandID)
{
    if (_module != NULL)
    {
        module = new char[strlen(_module) + 1];
        strncpy(module,_module,strlen(_module));
        module[strlen(_module)] = '\0';
	}
	else { module = new char[1]; module[0] = '\0'; }
	
    if (_file != NULL)
    {
        file = new char[strlen(_file) + 1];
        strncpy(file,_file,strlen(_file));
        file[strlen(_file)] = '\0';
	}
	else { file = new char[1]; file[0] = '\0'; }
	
    fileReceived = new char[1];
    fileReceived[0] = '\0';
    
    members->add(&module, nmMemberList::charstarType, strlen(module));
    members->add(&file, nmMemberList::charstarType, strlen(file));
    members->add(&fileReceived, nmMemberList::fileType, strlen(fileReceived));
}

nmFetchConfig::~nmFetchConfig()
{
    if (QFile::exists(fileReceived))
    {
        remove(fileReceived);
        delete[] fileReceived;
    }
    delete[] module;
    delete[] file;
}

// rework the linked list to return a file.
int nmFetchConfig::activate()
{
    return 1;
}

void nmFetchConfig::prepareToSend()
{
    delete members->nextMember;
    members->nextMember = NULL;
    members->add(&module, nmMemberList::charstarType, strlen(module));
    members->add(&file, nmMemberList::charstarType, strlen(file));
}
