/*
 * nmAlgInit.cc
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "cipher.h"
#include "nmAlgInit.h"

nmAlgInit::nmAlgInit(transport* connection, unsigned long sessionID, unsigned long commandID)
    : netmessage(connection, sessionID, commandID)
{
    h = k = e = m = c = NULL;
    members->add(&h, nmMemberList::charstarType, 0);
    members->add(&k, nmMemberList::charstarType, 0);
    members->add(&e, nmMemberList::charstarType, 0);
    members->add(&m, nmMemberList::charstarType, 0);
    members->add(&c, nmMemberList::charstarType, 0);
}

nmAlgInit::~nmAlgInit(void)
{
    if (h != NULL)
    {
        delete h;
    }

    if (k != NULL)
    {
        delete k;
    }

    if (e != NULL)
    {
        delete e;
    }

    if (m != NULL)
    {
        delete m;
    }

    if (c != NULL)
    {
        delete c;
    }
}

int nmAlgInit::activate(void)
{
    return 1;
}

void nmAlgInit::prepareToSend(void)
{
    nmMemberList* currMember;

    h = strdup("none");
    currMember = members->nextMember;
    currMember->length = strlen(h);

    k = strdup("diffie-hellman-random-sha1");
    currMember = currMember->nextMember;
    currMember->length = strlen(k);

    e = strdup("3des-cbc");
    currMember = currMember->nextMember;
    currMember->length = strlen(e);

    m = strdup("none");
    currMember = currMember->nextMember;
    currMember->length = strlen(m);

    c = strdup("none");
    currMember = currMember->nextMember;
    currMember->length = strlen(c);
}

