/*********************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nm_users.h
 *
 * this class implements the virtual methods out of the netmessage
 * class.  this class serializes the request to set the pasword on the
 * server host.
 *********************************************************************/

#ifndef NMUSERS_H
#define NMUSERS_H

#include <string>

#include "netmessage.h"

/* actions */
#define NMUSERS_ADD_USER            1
#define NMUSERS_REMOVE_USER         2
#define NMUSERS_CHANGE_PASSWORD     3
#define NMUSERS_LIST_ALL            4

#define NMUSERS_USER_ADDED        101
#define NMUSERS_USER_REMOVED      102
#define NMUSERS_PASSWORD_CHANGED  103

#define NMUSERS_USER_EXISTS       201
#define NMUSERS_USER_NOTEXISTS    202

class nmUsers: public netmessage
{
    public:
        nmUsers(char* user, char* passwd, int action, transport * connection, unsigned long sessionID, unsigned long commandID);
        ~nmUsers();
        
        int activate();
        void prepareToSend();
    
        char* netUser;
        char* netPasswd;
        int netAction;
                    
};

#endif
