#ifndef __nmStrStream_h_
#define __nmStrStream_h_

#include "netmessage.h"

#define TooFull 0
#define Successful 1
#define StrStreamCapacity 10

class nmStrStream: public netmessage
{
    public:
        nmStrStream(transport * connection, 
                    unsigned long sessionID, 
                    unsigned long commandID);
        ~nmStrStream();
        
        /* standard netmessage virtual classes */
        virtual int activate();
        virtual void prepareToSend();
    
        /* counts from 0, of course */
        char* getStr(int index);
        
        /* these functions can be used to get the current "fullness" */
        int amtStrs() { return filled; }
        bool lastPacket();
        
        /* use this to get the sequence number, as set on the server side */
        int getSequence() { return sequence; }
        
        
    private:
        int sequence, filled;
        char* strings[10];
};

#endif
